/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android.apptools;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.j256.ormlite.android.AndroidConnectionSource;
import com.j256.ormlite.android.AndroidDatabaseConnection;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.RuntimeExceptionDao;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.DatabaseTableConfigLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrmLiteSqliteOpenHelper
extends SQLiteOpenHelper {
    protected static Logger logger = LoggerFactory.getLogger(OrmLiteSqliteOpenHelper.class);
    protected AndroidConnectionSource connectionSource = new AndroidConnectionSource(this);
    protected boolean cancelQueriesEnabled;
    private volatile boolean isOpen = true;

    public OrmLiteSqliteOpenHelper(Context context, String databaseName, SQLiteDatabase.CursorFactory factory, int databaseVersion) {
        super(context, databaseName, factory, databaseVersion);
        logger.trace("{}: constructed connectionSource {}", (Object)this, (Object)this.connectionSource);
    }

    public OrmLiteSqliteOpenHelper(Context context, String databaseName, SQLiteDatabase.CursorFactory factory, int databaseVersion, int configFileId) {
        this(context, databaseName, factory, databaseVersion, OrmLiteSqliteOpenHelper.openFileId(context, configFileId));
    }

    public OrmLiteSqliteOpenHelper(Context context, String databaseName, SQLiteDatabase.CursorFactory factory, int databaseVersion, File configFile) {
        this(context, databaseName, factory, databaseVersion, OrmLiteSqliteOpenHelper.openFile(configFile));
    }

    public OrmLiteSqliteOpenHelper(Context context, String databaseName, SQLiteDatabase.CursorFactory factory, int databaseVersion, InputStream stream) {
        super(context, databaseName, factory, databaseVersion);
        if (stream == null) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream), 4096);
            DaoManager.addCachedDatabaseConfigs((Collection)DatabaseTableConfigLoader.loadDatabaseConfigFromReader((BufferedReader)reader));
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not load object config file", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    public abstract void onCreate(SQLiteDatabase var1, ConnectionSource var2);

    public abstract void onUpgrade(SQLiteDatabase var1, ConnectionSource var2, int var3, int var4);

    public ConnectionSource getConnectionSource() {
        if (!this.isOpen) {
            logger.warn((Throwable)new IllegalStateException(), "Getting connectionSource was called after closed");
        }
        return this.connectionSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onCreate(SQLiteDatabase db) {
        ConnectionSource cs = this.getConnectionSource();
        DatabaseConnection conn = cs.getSpecialConnection();
        boolean clearSpecial = false;
        if (conn == null) {
            conn = new AndroidDatabaseConnection(db, true, this.cancelQueriesEnabled);
            try {
                cs.saveSpecialConnection(conn);
                clearSpecial = true;
            }
            catch (SQLException e) {
                throw new IllegalStateException("Could not save special connection", e);
            }
        }
        try {
            this.onCreate(db, cs);
        }
        finally {
            if (clearSpecial) {
                cs.clearSpecialConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        ConnectionSource cs = this.getConnectionSource();
        DatabaseConnection conn = cs.getSpecialConnection();
        boolean clearSpecial = false;
        if (conn == null) {
            conn = new AndroidDatabaseConnection(db, true, this.cancelQueriesEnabled);
            try {
                cs.saveSpecialConnection(conn);
                clearSpecial = true;
            }
            catch (SQLException e) {
                throw new IllegalStateException("Could not save special connection", e);
            }
        }
        try {
            this.onUpgrade(db, cs, oldVersion, newVersion);
        }
        finally {
            if (clearSpecial) {
                cs.clearSpecialConnection(conn);
            }
        }
    }

    public void close() {
        super.close();
        this.connectionSource.close();
        this.isOpen = false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public <D extends Dao<T, ?>, T> D getDao(Class<T> clazz) throws SQLException {
        Dao dao;
        Dao castDao = dao = DaoManager.createDao((ConnectionSource)this.getConnectionSource(), clazz);
        return (D)castDao;
    }

    public <D extends RuntimeExceptionDao<T, ?>, T> D getRuntimeExceptionDao(Class<T> clazz) {
        try {
            D dao = this.getDao(clazz);
            RuntimeExceptionDao castDao = new RuntimeExceptionDao(dao);
            return (D)castDao;
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not create RuntimeExcepitionDao for class " + clazz, e);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "@" + Integer.toHexString(super.hashCode());
    }

    private static InputStream openFileId(Context context, int fileId) {
        InputStream stream = context.getResources().openRawResource(fileId);
        if (stream == null) {
            throw new IllegalStateException("Could not find object config file with id " + fileId);
        }
        return stream;
    }

    private static InputStream openFile(File configFile) {
        try {
            if (configFile == null) {
                return null;
            }
            return new FileInputStream(configFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Could not open config file " + configFile, e);
        }
    }
}

