/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.ResponseHandlerInterface;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.util.ByteArrayBuffer;

public abstract class AsyncHttpResponseHandler
implements ResponseHandlerInterface {
    private static final String LOG_TAG = "AsyncHttpResponseHandler";
    protected static final int SUCCESS_MESSAGE = 0;
    protected static final int FAILURE_MESSAGE = 1;
    protected static final int START_MESSAGE = 2;
    protected static final int FINISH_MESSAGE = 3;
    protected static final int PROGRESS_MESSAGE = 4;
    protected static final int RETRY_MESSAGE = 5;
    protected static final int CANCEL_MESSAGE = 6;
    protected static final int BUFFER_SIZE = 4096;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private String responseCharset = "UTF-8";
    private Handler handler;
    private boolean useSynchronousMode;
    private URI requestURI = null;
    private Header[] requestHeaders = null;

    @Override
    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public Header[] getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public void setRequestURI(URI requestURI) {
        this.requestURI = requestURI;
    }

    @Override
    public void setRequestHeaders(Header[] requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    @Override
    public boolean getUseSynchronousMode() {
        return this.useSynchronousMode;
    }

    @Override
    public void setUseSynchronousMode(boolean value) {
        if (!value && Looper.myLooper() == null) {
            value = true;
            Log.w((String)LOG_TAG, (String)"Current thread has not called Looper.prepare(). Forcing synchronous mode.");
        }
        if (!value && this.handler == null) {
            this.handler = new ResponderHandler(this);
        } else if (value && this.handler != null) {
            this.handler = null;
        }
        this.useSynchronousMode = value;
    }

    public void setCharset(String charset) {
        this.responseCharset = charset;
    }

    public String getCharset() {
        return this.responseCharset == null ? DEFAULT_CHARSET : this.responseCharset;
    }

    public AsyncHttpResponseHandler() {
        this.setUseSynchronousMode(false);
    }

    public void onProgress(int bytesWritten, int totalSize) {
        Log.v((String)LOG_TAG, (String)String.format("Progress %d from %d (%2.0f%%)", bytesWritten, totalSize, totalSize > 0 ? (double)bytesWritten * 1.0 / (double)totalSize * 100.0 : -1.0));
    }

    public void onStart() {
    }

    public void onFinish() {
    }

    public abstract void onSuccess(int var1, Header[] var2, byte[] var3);

    public abstract void onFailure(int var1, Header[] var2, byte[] var3, Throwable var4);

    public void onRetry(int retryNo) {
        Log.d((String)LOG_TAG, (String)String.format("Request retry no. %d", retryNo));
    }

    public void onCancel() {
        Log.d((String)LOG_TAG, (String)"Request got cancelled");
    }

    @Override
    public final void sendProgressMessage(int bytesWritten, int bytesTotal) {
        this.sendMessage(this.obtainMessage(4, new Object[]{bytesWritten, bytesTotal}));
    }

    @Override
    public final void sendSuccessMessage(int statusCode, Header[] headers, byte[] responseBytes) {
        this.sendMessage(this.obtainMessage(0, new Object[]{statusCode, headers, responseBytes}));
    }

    @Override
    public final void sendFailureMessage(int statusCode, Header[] headers, byte[] responseBody, Throwable throwable) {
        this.sendMessage(this.obtainMessage(1, new Object[]{statusCode, headers, responseBody, throwable}));
    }

    @Override
    public final void sendStartMessage() {
        this.sendMessage(this.obtainMessage(2, null));
    }

    @Override
    public final void sendFinishMessage() {
        this.sendMessage(this.obtainMessage(3, null));
    }

    @Override
    public final void sendRetryMessage(int retryNo) {
        this.sendMessage(this.obtainMessage(5, new Object[]{retryNo}));
    }

    @Override
    public final void sendCancelMessage() {
        this.sendMessage(this.obtainMessage(6, null));
    }

    protected void handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                Object[] response = (Object[])message.obj;
                if (response != null && response.length >= 3) {
                    this.onSuccess((Integer)response[0], (Header[])response[1], (byte[])response[2]);
                    break;
                }
                Log.e((String)LOG_TAG, (String)"SUCCESS_MESSAGE didn't got enough params");
                break;
            }
            case 1: {
                Object[] response = (Object[])message.obj;
                if (response != null && response.length >= 4) {
                    this.onFailure((Integer)response[0], (Header[])response[1], (byte[])response[2], (Throwable)response[3]);
                    break;
                }
                Log.e((String)LOG_TAG, (String)"FAILURE_MESSAGE didn't got enough params");
                break;
            }
            case 2: {
                this.onStart();
                break;
            }
            case 3: {
                this.onFinish();
                break;
            }
            case 4: {
                Object[] response = (Object[])message.obj;
                if (response != null && response.length >= 2) {
                    try {
                        this.onProgress((Integer)response[0], (Integer)response[1]);
                    }
                    catch (Throwable t) {
                        Log.e((String)LOG_TAG, (String)"custom onProgress contains an error", (Throwable)t);
                    }
                    break;
                }
                Log.e((String)LOG_TAG, (String)"PROGRESS_MESSAGE didn't got enough params");
                break;
            }
            case 5: {
                Object[] response = (Object[])message.obj;
                if (response != null && response.length == 1) {
                    this.onRetry((Integer)response[0]);
                    break;
                }
                Log.e((String)LOG_TAG, (String)"RETRY_MESSAGE didn't get enough params");
                break;
            }
            case 6: {
                this.onCancel();
            }
        }
    }

    protected void sendMessage(Message msg) {
        if (this.getUseSynchronousMode() || this.handler == null) {
            this.handleMessage(msg);
        } else if (!Thread.currentThread().isInterrupted()) {
            this.handler.sendMessage(msg);
        }
    }

    protected void postRunnable(Runnable runnable) {
        if (runnable != null) {
            if (this.getUseSynchronousMode() || this.handler == null) {
                runnable.run();
            } else {
                this.handler.post(runnable);
            }
        }
    }

    protected Message obtainMessage(int responseMessageId, Object responseMessageData) {
        Message msg;
        if (this.handler == null) {
            msg = Message.obtain();
            if (msg != null) {
                msg.what = responseMessageId;
                msg.obj = responseMessageData;
            }
        } else {
            msg = Message.obtain((Handler)this.handler, (int)responseMessageId, (Object)responseMessageData);
        }
        return msg;
    }

    @Override
    public void sendResponseMessage(HttpResponse response) throws IOException {
        if (!Thread.currentThread().isInterrupted()) {
            StatusLine status = response.getStatusLine();
            byte[] responseBody = this.getResponseData(response.getEntity());
            if (!Thread.currentThread().isInterrupted()) {
                if (status.getStatusCode() >= 300) {
                    this.sendFailureMessage(status.getStatusCode(), response.getAllHeaders(), responseBody, (Throwable)new HttpResponseException(status.getStatusCode(), status.getReasonPhrase()));
                } else {
                    this.sendSuccessMessage(status.getStatusCode(), response.getAllHeaders(), responseBody);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getResponseData(HttpEntity entity) throws IOException {
        InputStream instream;
        byte[] responseBody = null;
        if (entity != null && (instream = entity.getContent()) != null) {
            long contentLength = entity.getContentLength();
            if (contentLength > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
            }
            int buffersize = contentLength <= 0L ? 4096 : (int)contentLength;
            try {
                ByteArrayBuffer buffer = new ByteArrayBuffer(buffersize);
                try {
                    int l;
                    byte[] tmp = new byte[4096];
                    int count = 0;
                    while ((l = instream.read(tmp)) != -1 && !Thread.currentThread().isInterrupted()) {
                        buffer.append(tmp, 0, l);
                        this.sendProgressMessage(count += l, (int)(contentLength <= 0L ? 1L : contentLength));
                    }
                }
                finally {
                    AsyncHttpClient.silentCloseInputStream(instream);
                    AsyncHttpClient.endEntityViaReflection(entity);
                }
                responseBody = buffer.toByteArray();
            }
            catch (OutOfMemoryError e) {
                System.gc();
                throw new IOException("File too large to fit into available memory");
            }
        }
        return responseBody;
    }

    private static class ResponderHandler
    extends Handler {
        private final AsyncHttpResponseHandler mResponder;

        ResponderHandler(AsyncHttpResponseHandler mResponder) {
            this.mResponder = mResponder;
        }

        public void handleMessage(Message msg) {
            this.mResponder.handleMessage(msg);
        }
    }
}

