package com.rv.share.presenter;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import android.widget.Toast;

import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.share.BillActivity;
import com.rv.share.view.ShareChoiceDialog;
import com.umeng.socialize.ShareAction;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;

import java.io.File;

public class SharePresenter extends CommonPresenter {
    private ShareChoiceDialog dialog = null;
    private ShareAction shareAction = null;

    public void showShareDialog() {
        if (dialog == null) {
            dialog = new ShareChoiceDialog.Builder(getPresenterContext())
                    .setShareListener(myListener)
                    .setCopyVisiable(true)
                    .setWxVisiable(true)
                    .setWxCVisiable(true)
                    .setQQVisiable(true)
                    .setBillVisiable(true)
                    .create();
        }
        dialog.show();
    }

    /******
     * 分享地址
     * @param var1
     * @param var2
     */
    private void share(SHARE_MEDIA var1, String var2) {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(shareListener);
        }
        shareAction.setPlatform(var1)//传入平台
                .withText(var2);//分享内容
        shareAction.share();
    }

    /******
     * 分享文件
     * @param var1
     * @param var2
     */
    private void share(SHARE_MEDIA var1, File var2) {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(shareListener);
        }
        shareAction.setPlatform(var1)//传入平台
                .withFile(var2);//分享内容
        shareAction.share();
    }


    /*******
     * 复制地址
     * @param url
     */
    private void copy(String url) {
        ClipboardManager cm = (ClipboardManager) getPresenterContext().getSystemService(Context.CLIPBOARD_SERVICE);
        ClipData mClipData = ClipData.newRawUri("Label", Uri.parse(url));
        cm.setPrimaryClip(mClipData);
        Toast.makeText(getPresenterContext(), "复制成功", Toast.LENGTH_SHORT).show();
    }

    private UMShareListener shareListener = new UMShareListener() {
        @Override
        public void onStart(SHARE_MEDIA share_media) {
            Log.e("xxxxxxxxxx", "shareOnstart");
        }

        @Override
        public void onResult(SHARE_MEDIA share_media) {
            Log.e("xxxxxxxxxx", "shareonResult");
        }

        @Override
        public void onError(SHARE_MEDIA share_media, Throwable throwable) {
            Log.e("xxxxxxxxxx", "shareonError:" + throwable.getMessage());
        }

        @Override
        public void onCancel(SHARE_MEDIA share_media) {
            Log.e("xxxxxxxxxx", "shareonCancel");
        }
    };

    private ShareChoiceDialog.ShareListener myListener = new ShareChoiceDialog.ShareListener() {
        @Override
        public void copyShare() {
            copy("http://www.baidu.com");
        }

        @Override
        public void wxShare() {
            share(SHARE_MEDIA.WEIXIN, "hello");
        }

        @Override
        public void wxCShare() {
            share(SHARE_MEDIA.WEIXIN_CIRCLE, "hello");
        }

        @Override
        public void qqShare() {

        }

        @Override
        public void billShare() {
            getPresenterContext().startActivity(new Intent(getPresenterContext(), BillActivity.class));
        }

        @Override
        public void close() {
        }
    };
}
