package com.rv.share.presenter;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.share.BillActivity;
import com.rv.share.utils.StorageUtils;
import com.rv.share.view.ShareChoiceDialog;
import com.umeng.socialize.ShareAction;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.media.UMImage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class BillPresenter extends CommonPresenter {

    private ShareChoiceDialog dialog = null;
    private ShareAction shareAction = null;
    private LinearLayout view = null;
    private Bitmap bitmap = null;
    private UMImage image = null;

    public void showShareDialog(LinearLayout llBillContent) {
        this.view = llBillContent;
        if (dialog == null) {
            dialog = new ShareChoiceDialog.Builder(getPresenterContext())
                    .setShareListener(myListener)
                    .setWxVisiable(true)
                    .setWxCVisiable(true)
                    .setQQVisiable(true)
                    .create();
        }
        dialog.show();
    }

    /******
     * 分享地址
     * @param var1
     * @param var2
     */
    private void share(SHARE_MEDIA var1, String var2) {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(shareListener);
        }
        shareAction.setPlatform(var1)//传入平台
                .withText(var2);//分享内容
        shareAction.share();
    }

    /******
     * 分享文件
     * @param var1
     * @param var2
     */
    private void share(SHARE_MEDIA var1, UMImage var2, String content) {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(shareListener);
        }
        shareAction.setPlatform(var1)//传入平台
                .withText(content)
                .withMedia(var2);//分享内容
        shareAction.share();
    }

    /**
     * view转bitmap
     */
    public Bitmap viewConversionBitmap(View v) {
        int w = v.getWidth();
        int h = v.getHeight();
        int startX = (int) v.getX();
        int startY = (int) v.getY();
        Bitmap bmp = Bitmap.createBitmap(w, h, Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bmp);
        c.drawColor(Color.WHITE);
        v.layout(startX, startY, w + startX, h + startY);
        v.draw(c);
        return bmp;
    }

    public File saveBitmapFile(Bitmap bitmap) {

        File file = new File(StorageUtils.getCachePath(getPresenterContext()) + System.currentTimeMillis() + ".jpg");//将要保存图片的路径
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, bos);
            bos.flush();
            bos.close();

        } catch (IOException e) {
            e.printStackTrace();
        }

        return file;
    }

    private UMShareListener shareListener = new UMShareListener() {
        @Override
        public void onStart(SHARE_MEDIA share_media) {
            Log.e("xxxxxxxxxx", "shareOnstart");
        }

        @Override
        public void onResult(SHARE_MEDIA share_media) {
            Log.e("xxxxxxxxxx", "shareonResult");
        }

        @Override
        public void onError(SHARE_MEDIA share_media, Throwable throwable) {
            Log.e("xxxxxxxxxx", "shareonError:" + throwable.getMessage());
        }

        @Override
        public void onCancel(SHARE_MEDIA share_media) {
            Log.e("xxxxxxxxxx", "shareonCancel");
        }
    };

    private ShareChoiceDialog.ShareListener myListener = new ShareChoiceDialog.ShareListener() {

        private void shareDeal() {
            if (view != null && bitmap == null) {
                bitmap = viewConversionBitmap(view);
            }
            File file = null;
            if (bitmap != null) {
                file = saveBitmapFile(bitmap);
            }
            if (file != null) {
                image = new UMImage(getPresenterContext(), file);//bitmap文件
                image.compressStyle = UMImage.CompressStyle.SCALE;//大小压缩，默认为大小压缩，适合普通很大的图
                image.compressStyle = UMImage.CompressStyle.QUALITY;//质量压缩，适合长图的分享
                image.compressFormat = Bitmap.CompressFormat.PNG;
            }
        }

        @Override
        public void copyShare() {

        }

        @Override
        public void wxShare() {
            if (image == null) {
                shareDeal();
            }
            if (image != null) {
                share(SHARE_MEDIA.WEIXIN, image, "hello");
            }
        }

        @Override
        public void wxCShare() {
            share(SHARE_MEDIA.WEIXIN_CIRCLE, "hello");
        }

        @Override
        public void qqShare() {

        }

        @Override
        public void billShare() {

        }

        @Override
        public void close() {
        }
    };


    @Override
    public void detachView() {
        super.detachView();
        if (bitmap != null) {
            bitmap.recycle();
        }
    }


}
