package com.rv.home.rv.module.ui.main.home.order.adapter;

import android.text.TextUtils;
import android.widget.ImageView;

import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.ruiwenliu.wrapper.util.TimeManager;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;
import com.rv.home.rv.module.ui.main.home.order.bean.ToTravelBean;

import java.util.List;

/**
 * Created :Auser
 * Date: 2019/5/31.
 * Desc:已完成
 */

public class CompletedAdapter extends BaseMultiItemQuickAdapter<MultiItemEntity, BaseGlideHolder> {
    public static final int TYPE_FOR_PAYMENT = 1;
    public static final int TYPE_TO_TRAVEL = 2;
    public static final int TYPE_TO_MEMBER = 3;

    public CompletedAdapter(List<MultiItemEntity> data) {
        super(data);
        addItemType(TYPE_FOR_PAYMENT, R.layout.rv_item_order_for_payment);
        addItemType(TYPE_TO_TRAVEL, R.layout.rv_item_order_to_travel);
        addItemType(TYPE_TO_MEMBER, R.layout.rv_item_order_to_member);
    }

    @Override
    protected void convert(BaseGlideHolder helper, MultiItemEntity item) {
        switch (helper.getItemViewType()) {
            case TYPE_FOR_PAYMENT:
                OrderListBean.DataBeanX.DataBean dataBean = (OrderListBean.DataBeanX.DataBean) item;
                if (dataBean ==null){
                    return;
                }
                helper.setText(R.id.tv_order_time, String.format("%1$s%2$s", mContext.getString(R.string.rv_order_time), dataBean.getCrtTime()));
                if (dataBean.getOrderRentVehicleDetail() !=null && dataBean.getOrderRentVehicleDetail().getStart_city_name()!=null) {
                    helper.setText(R.id.tv_city, dataBean.getOrderRentVehicleDetail().getStart_city_name());
                }
                helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_completed));
                helper.loadRoundImage(mContext, dataBean.getIcon(), (ImageView) helper.getView(R.id.iv_goods), 10);
                helper.setText(R.id.tv_car_type, dataBean.getName());
                if (dataBean.getOrderRentVehicleDetail() !=null) {
                    helper.setText(R.id.tv_get_time, TimeManager.stampToDate(String.valueOf(dataBean.getOrderRentVehicleDetail().getStart_time())));
                    helper.setText(R.id.tv_get_address, dataBean.getOrderRentVehicleDetail().getStart_addr());
                    helper.setText(R.id.tv_out_time, TimeManager.stampToDate(String.valueOf(dataBean.getOrderRentVehicleDetail().getEnd_time())));
                    helper.setText(R.id.tv_out_address, dataBean.getOrderRentVehicleDetail().getEnd_addr());
                }
                helper.setText(R.id.tv_price, String.format("¥%1$s", dataBean.getRealAmount()));
                helper.setText(R.id.tv_process, mContext.getString(R.string.rv_to_evaluation));
                helper.addOnClickListener(R.id.tv_process);
                break;
            case TYPE_TO_TRAVEL:
                OrderListBean.DataBeanX.DataBean dataBean2 = (OrderListBean.DataBeanX.DataBean) item;
                if (dataBean2 == null) {
                    return;
                }
                if (dataBean2.getOrderTourDetail() ==null ){
                    return;
                }
                helper.setText(R.id.tv_order_time, String.format("%1$s%2$s", mContext.getString(R.string.rv_order_time), dataBean2.getCrtTime()));
                helper.setText(R.id.tv_city, dataBean2.getOrderTourDetail().getStartCityName());
                helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_completed));
                helper.loadRoundImage(mContext, dataBean2.getPicture(), (ImageView) helper.getView(R.id.iv_goods), 50);
                helper.setText(R.id.tv_car_type, dataBean2.getName());
                helper.setText(R.id.tv_out_time, mContext.getString(R.string.rv_to_time) +TimeManager.stampToDate2(String.valueOf( dataBean2.getOrderTourDetail().getStartTime())));
                helper.setText(R.id.tv_count_person, String.format("%1$s%2$s", mContext.getString(R.string.rv_to_person), dataBean2.getOrderTourDetail().getTotalNumber(), mContext.getString(R.string.rv_person)));
                helper.setText(R.id.tv_price, String.format("¥%1$s", dataBean2.getRealAmount()));
                helper.setText(R.id.tv_camp_process, mContext.getString(R.string.rv_to_evaluation));
                helper.addOnClickListener(R.id.tv_camp_process);
                break;
            case TYPE_TO_MEMBER:
                OrderListBean.DataBeanX.DataBean dataBean3 = (OrderListBean.DataBeanX.DataBean) item;
                if (dataBean3 ==null){
                    return;
                }
                if (dataBean3.getOrderMemberDetail() ==null){
                    return;
                }

                helper.setText(R.id.tv_order_time, String.format("%1$s%2$s", mContext.getString(R.string.rv_order_time), dataBean3.getCrtTime()));
                helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_completed));
                helper.loadRoundImage(mContext, dataBean3.getPicture(), (ImageView) helper.getView(R.id.iv_goods), 10);
                helper.setText(R.id.tv_name, dataBean3.getName());
                helper.setText(R.id.tv_content,dataBean3.getOrderMemberDetail().getContent() );
                helper.setText(R.id.tv_price, String.format("¥%1$s", dataBean3.getRealAmount()));
                helper.setVisible(R.id.tv_member_pay,false);
//                helper.setText(R.id.tv_member_pay, mContext.getString(R.string.rv_to_pay_for));
//                helper.addOnClickListener(R.id.tv_member_pay);
                break;
        }
    }

    public void addNewData(OrderListBean bean) {
        mData.clear();
        addData(bean.getData().getData());
        notifyDataSetChanged();

    }
}

