package com.rv.component.utils;

import android.content.Context;
import android.content.SharedPreferences;

public class Cooker {

    private final static String COOK_FILE = "cooker";

    private static SharedPreferences preferences;

    private static SharedPreferences getPreference(Context context) {
        if (preferences == null) {
            preferences = context.getSharedPreferences(COOK_FILE, Context.MODE_PRIVATE);
        }
        return preferences;
    }

    public static void save(Context context, String key, String s) {
        getPreference(context).edit().putString(key, s).commit();
    }

    public static void save(Context context, String key, int i) {
        getPreference(context).edit().putInt(key, i).commit();
    }

    public static void save(Context context, String key, long l) {
        getPreference(context).edit().putLong(key, l).commit();
    }

    public static void save(Context context, String key, boolean b) {
        getPreference(context).edit().putBoolean(key, b).commit();
    }

    public static void save(Context context, String key, float f) {
        getPreference(context).edit().putFloat(key, f).commit();
    }

    public static String getStringValue(Context context, String key) {
        return getStringValue(context, key, "");
    }

    public static String getStringValue(Context context, String key, String def) {
        return getPreference(context).getString(key, def);
    }

    public static int getIntValue(Context context, String key) {
        return getIntValue(context, key, -1);
    }

    public static int getIntValue(Context context, String key, int def) {
        return getPreference(context).getInt(key, def);
    }

    public static long getLongValue(Context context, String key) {
        return getLongValue(context, key, 0l);
    }

    public static long getLongValue(Context context, String key, long def) {
        return getPreference(context).getLong(key, def);
    }

    public static float getFloatValue(Context context, String key) {
        return getFloatValue(context, key, 0f);
    }

    public static float getFloatValue(Context context, String key, float def) {
        return getPreference(context).getFloat(key, def);
    }

    public static boolean getBooleanValue(Context context, String key) {
        return getBooleanValue(context, key, false);
    }

    public static boolean getBooleanValue(Context context, String key, boolean def) {
        return getPreference(context).getBoolean(key, def);
    }


}
