package com.rv.component.utils;

import android.content.Context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/******
 * 缓存管理
 */
public class Cache<T extends Serializable> {
    private static Cache instance = null;
    private Context mContext;

    private Cache(Context context) {
        this.mContext = context;
    }

    public static <T> Cache getInstance(Context context) {
        if (instance == null) {
            instance = new Cache(context);
        }
        return instance;
    }

    /********
     * 保存
     * @param bean
     */
    public void save(T bean, CacheEnum anEnum) {
        if (bean == null) {
            return;
        }
        saveObject(bean, anEnum);
    }

    private void saveObject(T bean, CacheEnum anEnum) {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        File f = new File(getSavePath(anEnum));
        try {
            fos = new FileOutputStream(f);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(bean);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getSavePath(CacheEnum anEnum) {
        return mContext.getCacheDir().getPath() + File.separator + anEnum.getFileName();
    }


    public T get(CacheEnum cacheEnum) {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        T o = null;
        File f = new File(getSavePath(cacheEnum));
        if (!f.exists()) {
            return null;
        }
        try {
            fis = new FileInputStream(f);
            ois = new ObjectInputStream(fis);
            o = (T) ois.readObject();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } finally {
            try {
                if (ois != null) {
                    ois.close();
                }
                if (fis != null) {
                    fis.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return o;
    }

    public void clear(CacheEnum cacheEnum) {
        File f = new File(getSavePath(cacheEnum));
        if (f.exists()) {
            f.delete();
        }
    }
}
