package com.base.utils.tools.android;

import android.os.CountDownTimer;

/**
 * 倒计时工具
 */
public class CountDownTimerUtil {
    private static CountDownTimer countDownTimer;   //倒时
    private static int stopValue = 0;               //倒计时停止时，返回停止的那一个时间

    /**
     * 开始
     */
    public static void start(int seconds, final onCountDownTimerListener listener) {
        thisListener = listener;
        if (countDownTimer != null) {
            countDownTimer.cancel();
        }
        countDownTimer = new CountDownTimer(seconds * 1000, 1000) {
            @Override
            public void onTick(long millisUntilFinished) {
                stopValue = (int) (millisUntilFinished / 1000);
                if (listener!=null){
                    listener.onTick(stopValue);
                }
            }

            @Override
            public void onFinish() {
                stopValue = 0;
                if (listener!=null){
                    listener.onFinish();
                }
            }
        }.start();
    }

    /**
     * 停止
     */
    public static int stop() {
        if (countDownTimer != null) {
            countDownTimer.cancel();
        }
        return stopValue;
    }

    /**
     * 继续上一次的倒计时
     */
    public static void continuePrevious() {
        start(stopValue,thisListener);
    }
    private static onCountDownTimerListener thisListener;
    public interface onCountDownTimerListener {
        void onTick(long millisUntilFinished);
        void onFinish();
    }
}
