package com.rv.travel.adapter;

import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.travel.R;
import com.rv.travel.bean.BeanTravelMember;

import java.util.List;

public class AdapterTravelMember extends BaseQuickAdapter<BeanTravelMember, AdapterTravelMember.AdapterViewHolder> {
    public interface OnItemAllClickListener {
        void onItemRootClick(BeanTravelMember bean);

        void onItemDeleteClick(BeanTravelMember bean);
    }

    private OnItemAllClickListener itemClickListener;

    public void setItemRootClickListener(OnItemAllClickListener itemClickListener) {
        this.itemClickListener = itemClickListener;
    }


    public AdapterTravelMember(int layoutResId, @Nullable List<BeanTravelMember> data) {
        super(layoutResId, data);
    }


    @Override
    protected void convert(AdapterTravelMember.AdapterViewHolder helper, BeanTravelMember item) {
        helper.nameView.setText(item.getName());

        helper.itemRoot.setTag(item);
        helper.itemRoot.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (itemClickListener != null) {
                    BeanTravelMember BeanTravelMember = (BeanTravelMember) v.getTag();
                    itemClickListener.onItemRootClick(BeanTravelMember);
                }
            }
        });
        helper.deleteView.setTag(item);
        helper.deleteView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (itemClickListener != null) {
                    BeanTravelMember BeanTravelMember = (BeanTravelMember) v.getTag();
                    itemClickListener.onItemDeleteClick(BeanTravelMember);
                }
            }
        });

        if (item.getIsChild().equals("0")) {
            helper.isChildView.setText("成人");
        } else {
            helper.isChildView.setText("儿童");
        }

        helper.mobileView.setText(item.getPhone());
        helper.nameView.setText(item.getName());
        if (TextUtil.isEmpty(item.getIdCard())) {
            helper.idCardTipView.setVisibility(View.INVISIBLE);
        } else {
            helper.idCardTipView.setVisibility(View.VISIBLE);
        }
        helper.idCardView.setText(item.getIdCard());
    }

    public class AdapterViewHolder extends BaseViewHolder {


        LinearLayout itemRoot;
        ImageView deleteView;
        TextView nameView;
        TextView mobileView;
        TextView idCardView;
        TextView idCardTipView;
        TextView isChildView;

        public AdapterViewHolder(View view) {
            super(view);
            itemRoot = view.findViewById(R.id.item_travel_member_root);
            deleteView = view.findViewById(R.id.item_travel_member_delete);
            nameView = view.findViewById(R.id.item_travel_member_name);
            mobileView = view.findViewById(R.id.item_travel_member_mobile);
            idCardView = view.findViewById(R.id.item_travel_member_id_card);
            idCardTipView = view.findViewById(R.id.item_travel_member_id_card_tip);
            isChildView = view.findViewById(R.id.item_travel_member_is_child);
        }
    }
}
