/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard.widgets;

import android.annotation.TargetApi;
import android.os.Build;
import android.view.KeyEvent;

class KeyEventCompat {
    private static final KeyEventVersionImpl IMPL = Build.VERSION.SDK_INT >= 11 ? new HoneycombKeyEventVersionImpl() : new BaseKeyEventVersionImpl();

    KeyEventCompat() {
    }

    public static boolean hasModifiers(KeyEvent event, int modifiers) {
        return IMPL.metaStateHasModifiers(event.getMetaState(), modifiers);
    }

    public static boolean hasNoModifiers(KeyEvent event) {
        return IMPL.metaStateHasNoModifiers(event.getMetaState());
    }

    @TargetApi(value=11)
    private static class HoneycombKeyEventVersionImpl
    extends BaseKeyEventVersionImpl {
        private HoneycombKeyEventVersionImpl() {
        }

        @Override
        public boolean metaStateHasModifiers(int metaState, int modifiers) {
            return KeyEvent.metaStateHasModifiers((int)metaState, (int)modifiers);
        }

        @Override
        public boolean metaStateHasNoModifiers(int metaState) {
            return KeyEvent.metaStateHasNoModifiers((int)metaState);
        }
    }

    private static class BaseKeyEventVersionImpl
    implements KeyEventVersionImpl {
        private static final int META_MODIFIER_MASK = 247;
        private static final int META_ALL_MASK = 247;

        private BaseKeyEventVersionImpl() {
        }

        private static int metaStateFilterDirectionalModifiers(int metaState, int modifiers, int basic, int left, int right) {
            boolean wantLeftOrRight;
            boolean wantBasic = (modifiers & basic) != 0;
            int directional = left | right;
            boolean bl = wantLeftOrRight = (modifiers & directional) != 0;
            if (wantBasic) {
                if (wantLeftOrRight) {
                    throw new IllegalArgumentException("bad arguments");
                }
                return metaState & ~directional;
            }
            if (wantLeftOrRight) {
                return metaState & ~basic;
            }
            return metaState;
        }

        private int normalizeMetaState(int metaState) {
            if ((metaState & 0xC0) != 0) {
                metaState |= 1;
            }
            if ((metaState & 0x30) != 0) {
                metaState |= 2;
            }
            return metaState & 0xF7;
        }

        @Override
        public boolean metaStateHasModifiers(int metaState, int modifiers) {
            metaState = this.normalizeMetaState(metaState) & 0xF7;
            metaState = BaseKeyEventVersionImpl.metaStateFilterDirectionalModifiers(metaState, modifiers, 1, 64, 128);
            return (metaState = BaseKeyEventVersionImpl.metaStateFilterDirectionalModifiers(metaState, modifiers, 2, 16, 32)) == modifiers;
        }

        @Override
        public boolean metaStateHasNoModifiers(int metaState) {
            return (this.normalizeMetaState(metaState) & 0xF7) == 0;
        }
    }

    static interface KeyEventVersionImpl {
        public boolean metaStateHasModifiers(int var1, int var2);

        public boolean metaStateHasNoModifiers(int var1);
    }
}

