/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.b;

public final class LatLngBounds
implements Parcelable {
    public final LatLng northeast;
    public final LatLng southwest;
    public static final Parcelable.Creator<LatLngBounds> CREATOR = new b();

    LatLngBounds(LatLng latLng, LatLng latLng2) {
        this.northeast = latLng;
        this.southwest = latLng2;
    }

    protected LatLngBounds(Parcel parcel) {
        this.northeast = (LatLng)parcel.readParcelable(LatLng.class.getClassLoader());
        this.southwest = (LatLng)parcel.readParcelable(LatLng.class.getClassLoader());
    }

    public boolean contains(LatLng latLng) {
        if (latLng == null) {
            return false;
        }
        double d2 = this.southwest.latitude;
        double d3 = this.northeast.latitude;
        double d4 = this.southwest.longitude;
        double d5 = this.northeast.longitude;
        double d6 = latLng.latitude;
        double d7 = latLng.longitude;
        return d6 >= d2 && d6 <= d3 && d7 >= d4 && d7 <= d5;
    }

    public LatLng getCenter() {
        double d2 = (this.northeast.latitude - this.southwest.latitude) / 2.0 + this.southwest.latitude;
        double d3 = (this.northeast.longitude - this.southwest.longitude) / 2.0 + this.southwest.longitude;
        LatLng latLng = new LatLng(d2, d3);
        return latLng;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeParcelable((Parcelable)this.northeast, n2);
        parcel.writeParcelable((Parcelable)this.southwest, n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("southwest: ");
        stringBuilder.append(this.southwest.latitude);
        stringBuilder.append(", ");
        stringBuilder.append(this.southwest.longitude);
        stringBuilder.append("\n");
        stringBuilder.append("northeast: ");
        stringBuilder.append(this.northeast.latitude);
        stringBuilder.append(", ");
        stringBuilder.append(this.northeast.longitude);
        return stringBuilder.toString();
    }

    public static final class Builder {
        private double a;
        private double b;
        private double c;
        private double d;
        private boolean e = true;

        public LatLngBounds build() {
            LatLng latLng = new LatLng(this.b, this.d);
            LatLng latLng2 = new LatLng(this.a, this.c);
            return new LatLngBounds(latLng, latLng2);
        }

        public Builder include(LatLng latLng) {
            if (latLng == null) {
                return this;
            }
            if (this.e) {
                this.e = false;
                this.b = this.a = latLng.latitude;
                this.d = this.c = latLng.longitude;
            }
            double d2 = latLng.latitude;
            double d3 = latLng.longitude;
            if (d2 < this.a) {
                this.a = d2;
            }
            if (d2 > this.b) {
                this.b = d2;
            }
            if (d3 < this.c) {
                this.c = d3;
            }
            if (d3 > this.d) {
                this.d = d3;
            }
            return this;
        }
    }
}

