/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.mapapi.common.SysOSUtil;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.HeatMap;
import com.baidu.mapapi.map.InfoWindow;
import com.baidu.mapapi.map.MapBaseIndoorMapInfo;
import com.baidu.mapapi.map.MapPoi;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.map.MapStatusUpdateFactory;
import com.baidu.mapapi.map.MapView;
import com.baidu.mapapi.map.MapViewLayoutParams;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.MyLocationConfiguration;
import com.baidu.mapapi.map.MyLocationData;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.Polyline;
import com.baidu.mapapi.map.Projection;
import com.baidu.mapapi.map.TextureMapView;
import com.baidu.mapapi.map.TileOverlay;
import com.baidu.mapapi.map.TileOverlayOptions;
import com.baidu.mapapi.map.UiSettings;
import com.baidu.mapapi.map.WearMapView;
import com.baidu.mapapi.map.a;
import com.baidu.mapapi.map.b;
import com.baidu.mapapi.map.c;
import com.baidu.mapapi.map.d;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.LatLngBounds;
import com.baidu.mapapi.model.ParcelItem;
import com.baidu.mapapi.model.inner.GeoPoint;
import com.baidu.mapsdkplatform.comapi.map.aa;
import com.baidu.mapsdkplatform.comapi.map.ab;
import com.baidu.mapsdkplatform.comapi.map.ac;
import com.baidu.mapsdkplatform.comapi.map.e;
import com.baidu.mapsdkplatform.comapi.map.h;
import com.baidu.mapsdkplatform.comapi.map.j;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.opengles.GL10;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaiduMap {
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_NONE = 3;
    public static int mapStatusReason = 0;
    private static final String e = BaiduMap.class.getSimpleName();
    private Projection f;
    private UiSettings g;
    private j h;
    private e i;
    private ac j;
    private List<Overlay> k;
    private List<Marker> l;
    private List<Marker> m;
    private Overlay.a n;
    private OnMapStatusChangeListener o;
    private OnMapTouchListener p;
    private OnMapClickListener q;
    private OnMapLoadedCallback r;
    private OnMapRenderCallback s;
    private OnMapDoubleClickListener t;
    private OnMapLongClickListener u;
    private CopyOnWriteArrayList<OnMarkerClickListener> v = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<OnPolylineClickListener> w = new CopyOnWriteArrayList();
    private OnMarkerDragListener x;
    private OnMyLocationClickListener y;
    private SnapshotReadyCallback z;
    private OnMapDrawFrameCallback A;
    private OnBaseIndoorMapListener B;
    private OnSynchronizationListener C;
    private TileOverlay D;
    private HeatMap E;
    private Lock F = new ReentrantLock();
    private Lock G = new ReentrantLock();
    private InfoWindow H;
    private Marker I;
    private View J;
    private Marker K;
    private MyLocationData L;
    private MyLocationConfiguration M;
    MapView a;
    TextureMapView b;
    WearMapView c;
    aa d;
    private boolean N;
    private boolean O;
    private boolean P;
    private boolean Q;
    private Point R;

    private void c() {
        this.k = new CopyOnWriteArrayList<Overlay>();
        this.l = new CopyOnWriteArrayList<Marker>();
        this.m = new CopyOnWriteArrayList<Marker>();
        int n2 = (int)(40.0f * SysOSUtil.getDensity());
        int n3 = (int)(40.0f * SysOSUtil.getDensity());
        this.R = new Point(n2, n3);
        this.g = new UiSettings(this.i);
        this.n = new a(this);
        b b2 = new b(this);
        this.i.a(b2);
        c c2 = new c(this);
        this.i.a(c2);
        d d2 = new d(this);
        this.i.a(d2);
        this.N = this.i.C();
        this.O = this.i.D();
    }

    BaiduMap(ac ac2) {
        this.j = ac2;
        this.i = this.j.b();
        this.d = aa.b;
        this.c();
    }

    BaiduMap(j j2) {
        this.h = j2;
        this.i = this.h.a();
        this.d = aa.a;
        this.c();
    }

    public final Overlay addOverlay(OverlayOptions overlayOptions) {
        Marker marker;
        if (overlayOptions == null) {
            return null;
        }
        Overlay overlay = overlayOptions.a();
        overlay.listener = this.n;
        if (overlay instanceof Marker) {
            marker = (Marker)overlay;
            if (marker.o != null && marker.o.size() != 0) {
                this.l.add(marker);
                if (this.i != null) {
                    this.i.b(true);
                }
            }
            this.m.add(marker);
        }
        marker = new Bundle();
        overlay.a((Bundle)marker);
        if (this.i != null) {
            this.i.b((Bundle)marker);
        }
        this.k.add(overlay);
        return overlay;
    }

    public final List<Overlay> addOverlays(List<OverlayOptions> list) {
        Object object;
        if (list == null) {
            return null;
        }
        ArrayList<Overlay> arrayList = new ArrayList<Overlay>();
        Bundle[] bundleArray = new Bundle[list.size()];
        int n2 = 0;
        for (OverlayOptions overlayOptions : list) {
            if (overlayOptions == null) continue;
            object = new Bundle();
            Overlay overlay = overlayOptions.a();
            overlay.listener = this.n;
            if (overlay instanceof Marker) {
                Marker marker = (Marker)overlay;
                if (marker.o != null && marker.o.size() != 0) {
                    this.l.add(marker);
                    if (this.i != null) {
                        this.i.b(true);
                    }
                }
                this.m.add(marker);
            }
            this.k.add(overlay);
            arrayList.add(overlay);
            overlay.a((Bundle)object);
            bundleArray[n2] = object;
            ++n2;
        }
        int n3 = bundleArray.length / 400;
        for (int i2 = 0; i2 < n3 + 1; ++i2) {
            object = new ArrayList();
            for (int i3 = 0; i3 < 400 && i2 * 400 + i3 < bundleArray.length; ++i3) {
                if (bundleArray[i2 * 400 + i3] == null) continue;
                object.add(bundleArray[i2 * 400 + i3]);
            }
            if (this.i == null) continue;
            this.i.a((List<Bundle>)object);
        }
        return arrayList;
    }

    public List<Marker> getMarkersInBounds(LatLngBounds latLngBounds) {
        MapStatus mapStatus = this.getMapStatus();
        if (mapStatus == null) {
            return null;
        }
        ArrayList<Marker> arrayList = new ArrayList<Marker>();
        if (this.m.size() == 0) {
            return null;
        }
        for (Marker marker : this.m) {
            if (!latLngBounds.contains(marker.getPosition())) continue;
            arrayList.add(marker);
        }
        return arrayList;
    }

    public final void clear() {
        this.k.clear();
        this.l.clear();
        this.m.clear();
        if (this.i != null) {
            this.i.b(false);
            this.i.n();
        }
        this.hideInfoWindow();
    }

    public final void setMapStatus(MapStatusUpdate mapStatusUpdate) {
        if (mapStatusUpdate == null) {
            return;
        }
        ab ab2 = this.a(mapStatusUpdate);
        if (this.i == null) {
            return;
        }
        this.i.a(ab2);
        if (this.o != null) {
            this.o.onMapStatusChange(this.getMapStatus());
        }
    }

    public final MapStatus getMapStatus() {
        if (this.i == null) {
            return null;
        }
        ab ab2 = this.i.E();
        return MapStatus.a(ab2);
    }

    public final LatLngBounds getMapStatusLimit() {
        if (this.i == null) {
            return null;
        }
        return this.i.F();
    }

    public final void setMapStatusLimits(LatLngBounds latLngBounds) {
        if (this.i == null) {
            return;
        }
        this.i.a(latLngBounds);
        MapStatusUpdate mapStatusUpdate = MapStatusUpdateFactory.newLatLngBounds(latLngBounds);
        this.setMapStatus(mapStatusUpdate);
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate, int n2) {
        if (mapStatusUpdate == null || n2 <= 0) {
            return;
        }
        ab ab2 = this.a(mapStatusUpdate);
        if (this.i == null) {
            return;
        }
        mapStatusReason |= 0x100;
        if (!this.Q) {
            this.i.a(ab2);
        } else {
            this.i.a(ab2, n2);
        }
    }

    public float getZoomToBound(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.i == null) {
            return 0.0f;
        }
        return this.i.a(n2, n3, n4, n5, n6, n7);
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate) {
        this.animateMapStatus(mapStatusUpdate, 300);
    }

    private ab a(MapStatusUpdate mapStatusUpdate) {
        if (this.i == null) {
            return null;
        }
        ab ab2 = this.i.E();
        MapStatus mapStatus = mapStatusUpdate.a(this.i, this.getMapStatus());
        if (null == mapStatus) {
            return null;
        }
        ab ab3 = mapStatus.b(ab2);
        return ab3;
    }

    public final void setMapType(int n2) {
        if (this.i == null) {
            return;
        }
        switch (n2) {
            case 3: {
                if (this.i.C()) {
                    this.i.t(false);
                }
                if (this.i.D()) {
                    this.i.u(false);
                }
                this.i.f(false);
                this.i.k(false);
                break;
            }
            case 1: {
                this.i.a(false);
                this.i.t(this.N);
                this.i.u(this.O);
                this.i.f(true);
                this.i.k(this.P);
                break;
            }
            case 2: {
                this.i.a(true);
                this.i.t(this.N);
                this.i.u(this.O);
                this.i.f(true);
                break;
            }
        }
        if (this.h != null) {
            this.h.a(n2);
        }
    }

    public final int getMapType() {
        if (this.i == null) {
            return 1;
        }
        if (!this.i.l()) {
            return 3;
        }
        return this.i.k() ? 2 : 1;
    }

    public j getmGLMapView() {
        return this.h;
    }

    public final float getMaxZoomLevel() {
        if (this.i == null) {
            return 0.0f;
        }
        return this.i.a;
    }

    public final void setMaxAndMinZoomLevel(float f2, float f3) {
        if (f2 > 21.0f) {
            return;
        }
        if (f3 < 4.0f) {
            return;
        }
        if (f2 < f3) {
            return;
        }
        if (this.i != null) {
            this.i.a(f2, f3);
        }
    }

    public final float getMinZoomLevel() {
        if (this.i == null) {
            return 0.0f;
        }
        return this.i.b;
    }

    public final Projection getProjection() {
        return this.f;
    }

    public final UiSettings getUiSettings() {
        return this.g;
    }

    public final void setBuildingsEnabled(boolean bl) {
        if (this.i != null) {
            this.i.i(bl);
        }
    }

    public final boolean isBuildingsEnabled() {
        if (this.i == null) {
            return false;
        }
        return this.i.m();
    }

    public final void setMyLocationEnabled(boolean bl) {
        if (this.i != null) {
            this.i.m(bl);
        }
    }

    public final boolean isMyLocationEnabled() {
        if (this.i == null) {
            return false;
        }
        return this.i.s();
    }

    public final void setMyLocationData(MyLocationData myLocationData) {
        this.L = myLocationData;
        if (this.M == null) {
            this.M = new MyLocationConfiguration(MyLocationConfiguration.LocationMode.NORMAL, false, null);
        }
        this.a(myLocationData, this.M);
    }

    public final MyLocationData getLocationData() {
        return this.L;
    }

    public final void setMyLocationConfiguration(MyLocationConfiguration myLocationConfiguration) {
        this.M = myLocationConfiguration;
        this.a(this.L, this.M);
    }

    public final void setMyLocationConfigeration(MyLocationConfiguration myLocationConfiguration) {
        this.setMyLocationConfiguration(myLocationConfiguration);
    }

    public final MyLocationConfiguration getLocationConfiguration() {
        return this.M;
    }

    public final MyLocationConfiguration getLocationConfigeration() {
        return this.getLocationConfiguration();
    }

    private final void a(MyLocationData myLocationData, MyLocationConfiguration myLocationConfiguration) {
        Object object;
        Bundle bundle;
        if (myLocationData == null || myLocationConfiguration == null || !this.isMyLocationEnabled()) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        LatLng latLng = new LatLng(myLocationData.latitude, myLocationData.longitude);
        GeoPoint geoPoint = CoordUtil.ll2mc(latLng);
        try {
            jSONObject.put("type", 0);
            jSONObject2.put("ptx", geoPoint.getLongitudeE6());
            jSONObject2.put("pty", geoPoint.getLatitudeE6());
            float f2 = CoordUtil.getMCDistanceByOneLatLngAndRadius(latLng, (int)myLocationData.accuracy);
            jSONObject2.put("radius", (double)f2);
            float f3 = myLocationData.direction;
            if (myLocationConfiguration.enableDirection) {
                f3 = myLocationData.direction % 360.0f;
                if (f3 > 180.0f) {
                    f3 -= 360.0f;
                } else if (f3 < -180.0f) {
                    f3 += 360.0f;
                }
            } else {
                f3 = -1001.0f;
            }
            jSONObject2.put("direction", (double)f3);
            jSONObject2.put("iconarrownor", (Object)"NormalLocArrow");
            jSONObject2.put("iconarrownorid", 28);
            jSONObject2.put("iconarrowfoc", (Object)"FocusLocArrow");
            jSONObject2.put("iconarrowfocid", 29);
            jSONObject2.put("lineid", myLocationConfiguration.accuracyCircleStrokeColor);
            jSONObject2.put("areaid", myLocationConfiguration.accuracyCircleFillColor);
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("data", (Object)jSONArray);
            if (myLocationConfiguration.locationMode == MyLocationConfiguration.LocationMode.COMPASS) {
                jSONObject3.put("ptx", geoPoint.getLongitudeE6());
                jSONObject3.put("pty", geoPoint.getLatitudeE6());
                jSONObject3.put("radius", 0);
                jSONObject3.put("direction", 0);
                jSONObject3.put("iconarrownor", (Object)"direction_wheel");
                jSONObject3.put("iconarrownorid", 54);
                jSONObject3.put("iconarrowfoc", (Object)"direction_wheel");
                jSONObject3.put("iconarrowfocid", 54);
                jSONArray.put((Object)jSONObject3);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (myLocationConfiguration.customMarker == null) {
            bundle = null;
        } else {
            ArrayList<BitmapDescriptor> arrayList = new ArrayList<BitmapDescriptor>();
            arrayList.add(myLocationConfiguration.customMarker);
            bundle = new Bundle();
            object = new ArrayList();
            for (BitmapDescriptor bitmapDescriptor : arrayList) {
                ParcelItem parcelItem = new ParcelItem();
                Bundle bundle2 = new Bundle();
                Bitmap bitmap = bitmapDescriptor.a;
                ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
                bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
                byte[] byArray = byteBuffer.array();
                bundle2.putByteArray("imgdata", byArray);
                bundle2.putInt("imgindex", bitmapDescriptor.hashCode());
                bundle2.putInt("imgH", bitmap.getHeight());
                bundle2.putInt("imgW", bitmap.getWidth());
                parcelItem.setBundle(bundle2);
                ((ArrayList)object).add(parcelItem);
            }
            if (((ArrayList)object).size() > 0) {
                Parcelable[] parcelableArray = new ParcelItem[((ArrayList)object).size()];
                for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                    parcelableArray[i2] = (ParcelItem)((ArrayList)object).get(i2);
                }
                bundle.putParcelableArray("icondata", parcelableArray);
            }
        }
        if (this.i != null) {
            this.i.a(jSONObject.toString(), bundle);
        }
        switch (myLocationConfiguration.locationMode) {
            case COMPASS: {
                MapStatus mapStatus = new MapStatus.Builder().rotate(myLocationData.direction).overlook(-45.0f).target(new LatLng(myLocationData.latitude, myLocationData.longitude)).targetScreen(this.getMapStatus().targetScreen).zoom(this.getMapStatus().zoom).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case FOLLOWING: {
                MapStatus mapStatus = new MapStatus.Builder().target(new LatLng(myLocationData.latitude, myLocationData.longitude)).zoom(this.getMapStatus().zoom).rotate(this.getMapStatus().rotate).overlook(this.getMapStatus().overlook).targetScreen(this.getMapStatus().targetScreen).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case NORMAL: {
                break;
            }
        }
    }

    public void addHeatMap(HeatMap heatMap) {
        if (heatMap == null) {
            return;
        }
        this.F.lock();
        try {
            if (heatMap == this.E) {
                return;
            }
            if (this.E != null) {
                this.E.b();
                this.E.c();
                this.E.a = null;
                this.i.o();
            }
            this.E = heatMap;
            this.E.a = this;
            this.i.n(true);
        }
        finally {
            this.F.unlock();
        }
    }

    void a(HeatMap heatMap) {
        this.F.lock();
        try {
            if (this.E != null && this.i != null && heatMap == this.E) {
                this.E.b();
                this.E.c();
                this.E.a = null;
                this.i.o();
                this.E = null;
                this.i.n(false);
            }
        }
        finally {
            this.F.unlock();
        }
    }

    void a() {
        if (this.i == null) {
            return;
        }
        this.i.t();
    }

    public final void setBaiduHeatMapEnabled(boolean bl) {
        if (this.i != null) {
            this.i.g(bl);
        }
    }

    public final void setIndoorEnable(boolean bl) {
        if (this.i != null) {
            this.P = bl;
            this.i.k(bl);
        }
        if (this.B != null && !bl) {
            this.B.onBaseIndoorMapMode(false, null);
        }
    }

    public void setCompassPosition(Point point) {
        if (this.i.a(point)) {
            this.R = point;
        }
    }

    public void setCompassIcon(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException("compass's icon can not be null");
        }
        this.i.a(bitmap);
    }

    public final Point getCompassPosition() {
        if (this.i != null) {
            String string = this.i.h();
            return this.a(string);
        }
        return null;
    }

    private Point a(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        for (String string2 : string.replaceAll("^\\{", "").replaceAll("\\}$", "").split(",")) {
            String[] stringArray = string2.replaceAll("\"", "").split(":");
            if ("x".equals(stringArray[0])) {
                n2 = Integer.valueOf(stringArray[1]);
            }
            if (!"y".equals(stringArray[0])) continue;
            n3 = Integer.valueOf(stringArray[1]);
        }
        return new Point(n2, n3);
    }

    public final boolean isBaiduHeatMapEnabled() {
        if (this.i == null) {
            return false;
        }
        return this.i.i();
    }

    public final boolean isSupportBaiduHeatMap() {
        if (this.i == null) {
            return false;
        }
        return this.i.j();
    }

    public final void setTrafficEnabled(boolean bl) {
        if (this.i != null) {
            this.i.h(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean setCustomTrafficColor(String string, String string2, String string3, String string4) {
        String string5 = "^#[0-9a-fA-F]{8}$";
        if (!(TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string4))) {
            if (string.matches(string5) && string2.matches(string5) && string3.matches(string5) && string4.matches(string5)) {
                this.i.a(Color.parseColor((String)string), Color.parseColor((String)string2), Color.parseColor((String)string3), Color.parseColor((String)string4), true);
                return true;
            }
            Log.e((String)e, (String)"the string of the input customTrafficColor is error");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) return true;
        if (!TextUtils.isEmpty((CharSequence)string2)) return true;
        if (!TextUtils.isEmpty((CharSequence)string3)) return true;
        if (!TextUtils.isEmpty((CharSequence)string4)) return true;
        this.i.a(Color.parseColor((String)"#ffffffff"), Color.parseColor((String)"#ffffffff"), Color.parseColor((String)"#ffffffff"), Color.parseColor((String)"#ffffffff"), false);
        return true;
    }

    public final boolean isTrafficEnabled() {
        if (this.i == null) {
            return false;
        }
        return this.i.g();
    }

    public final void showMapPoi(boolean bl) {
        if (this.i != null) {
            this.i.t(bl);
            this.N = bl;
        }
    }

    public final void showMapIndoorPoi(boolean bl) {
        if (this.i != null) {
            this.i.u(bl);
            this.O = bl;
        }
    }

    @Deprecated
    public final void setPadding(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            return;
        }
        if (this.i == null) {
            return;
        }
        ab ab2 = this.i.E();
        switch (this.d) {
            case b: {
                if (this.b == null) {
                    return;
                }
                float f2 = (float)(this.b.getWidth() - n2 - n4) / (float)this.b.getWidth();
                float f3 = (float)(this.b.getHeight() - n3 - n5) / (float)this.b.getHeight();
                int n6 = this.b.getWidth() + n2 - n4;
                int n7 = this.b.getHeight() + n3 - n5;
                MapStatus mapStatus = new MapStatus.Builder().targetScreen(new Point(n6 / 2, n7 / 2)).build();
                MapStatusUpdate mapStatusUpdate = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.i.a(new Point((int)((float)n2 + (float)this.R.x * f2), (int)((float)n3 + (float)this.R.y * f3)));
                this.setMapStatus(mapStatusUpdate);
                this.b.setPadding(n2, n3, n4, n5);
                this.b.invalidate();
                break;
            }
            case a: {
                if (this.a == null) {
                    return;
                }
                float f4 = (float)(this.a.getWidth() - n2 - n4) / (float)this.a.getWidth();
                float f5 = (float)(this.a.getHeight() - n3 - n5) / (float)this.a.getHeight();
                int n8 = this.a.getWidth() + n2 - n4;
                int n9 = this.a.getHeight() + n3 - n5;
                MapStatus mapStatus = new MapStatus.Builder().targetScreen(new Point(n8 / 2, n9 / 2)).build();
                MapStatusUpdate mapStatusUpdate = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.i.a(new Point((int)((float)n2 + (float)this.R.x * f4), (int)((float)n3 + (float)this.R.y * f5)));
                this.setMapStatus(mapStatusUpdate);
                this.a.setPadding(n2, n3, n4, n5);
                this.a.invalidate();
                break;
            }
        }
    }

    public final void setViewPadding(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            return;
        }
        if (this.i == null) {
            return;
        }
        switch (this.d) {
            case b: {
                if (this.b == null) {
                    return;
                }
                float f2 = (float)(this.b.getWidth() - n2 - n4) / (float)this.b.getWidth();
                float f3 = (float)(this.b.getHeight() - n3 - n5) / (float)this.b.getHeight();
                this.i.a(new Point((int)((float)n2 + (float)this.R.x * f2), (int)((float)n3 + (float)this.R.y * f3)));
                this.b.setPadding(n2, n3, n4, n5);
                this.b.invalidate();
                break;
            }
            case a: {
                if (this.a == null) {
                    return;
                }
                float f4 = (float)(this.a.getWidth() - n2 - n4) / (float)this.a.getWidth();
                float f5 = (float)(this.a.getHeight() - n3 - n5) / (float)this.a.getHeight();
                this.i.a(new Point((int)((float)n2 + (float)this.R.x * f4), (int)((float)n3 + (float)this.R.y * f5)));
                this.a.setPadding(n2, n3, n4, n5);
                this.a.invalidate();
                break;
            }
        }
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        this.z = snapshotReadyCallback;
        switch (this.d) {
            case b: {
                if (this.j == null) break;
                this.j.a("anything", null);
                break;
            }
            case a: {
                if (this.h == null) break;
                this.h.a("anything", null);
                break;
            }
        }
    }

    public final void snapshotScope(Rect rect, SnapshotReadyCallback snapshotReadyCallback) {
        this.z = snapshotReadyCallback;
        switch (this.d) {
            case b: {
                if (this.j == null) break;
                this.j.a("anything", rect);
                break;
            }
            case a: {
                if (this.h == null) break;
                this.h.a("anything", rect);
                break;
            }
        }
    }

    public void showInfoWindow(InfoWindow infoWindow) {
        Object object;
        Object object2;
        if (null == infoWindow) {
            return;
        }
        this.hideInfoWindow();
        if (infoWindow.b != null) {
            this.J = infoWindow.b;
            this.J.destroyDrawingCache();
            object2 = new MapViewLayoutParams.Builder();
            object = ((MapViewLayoutParams.Builder)object2).layoutMode(MapViewLayoutParams.ELayoutMode.mapMode).position(infoWindow.c).yOffset(infoWindow.e).build();
            switch (this.d) {
                case b: {
                    if (this.b == null) break;
                    this.b.addView(this.J, (ViewGroup.LayoutParams)object);
                    break;
                }
                case a: {
                    if (this.h == null) break;
                    this.a.addView(this.J, (ViewGroup.LayoutParams)object);
                    break;
                }
            }
        }
        this.H = infoWindow;
        if (infoWindow.b != null) {
            if (infoWindow.f) {
                if (infoWindow.g <= 0) {
                    infoWindow.g = SysOSUtil.getDensityDpi();
                }
                object2 = BitmapDescriptorFactory.fromViewWithDpi(infoWindow.b, infoWindow.g);
            } else {
                object2 = BitmapDescriptorFactory.fromView(infoWindow.b);
            }
        } else {
            object2 = infoWindow.a;
        }
        object = new MarkerOptions().perspective(false).icon((BitmapDescriptor)object2).position(infoWindow.c).zIndex(Integer.MAX_VALUE).yOffset(infoWindow.e);
        Overlay overlay = ((MarkerOptions)object).a();
        overlay.listener = this.n;
        overlay.type = com.baidu.mapsdkplatform.comapi.map.h.b;
        Bundle bundle = new Bundle();
        overlay.a(bundle);
        if (infoWindow.b != null) {
            bundle.putInt("draw_with_view", 1);
        } else {
            bundle.putInt("draw_with_view", 0);
        }
        if (this.i != null) {
            this.i.b(bundle);
        }
        this.k.add(overlay);
        this.I = (Marker)overlay;
    }

    public void hideInfoWindow() {
        if (null == this.H) {
            return;
        }
        if (this.H.b != null) {
            switch (this.d) {
                case b: {
                    if (this.b == null) break;
                    this.b.removeView(this.J);
                    break;
                }
                case a: {
                    if (this.h == null) break;
                    this.a.removeView(this.J);
                    break;
                }
            }
            this.J = null;
        }
        this.H = null;
        this.I.remove();
        this.I = null;
    }

    public void setPixelFormatTransparent(boolean bl) {
        if (this.h == null) {
            return;
        }
        if (bl) {
            this.h.d();
        } else {
            this.h.e();
        }
    }

    public final void setOnMapStatusChangeListener(OnMapStatusChangeListener onMapStatusChangeListener) {
        this.o = onMapStatusChangeListener;
    }

    public final void setOnMapTouchListener(OnMapTouchListener onMapTouchListener) {
        this.p = onMapTouchListener;
    }

    public final void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.q = onMapClickListener;
    }

    public void setOnMapLoadedCallback(OnMapLoadedCallback onMapLoadedCallback) {
        this.r = onMapLoadedCallback;
    }

    public void setOnMapRenderCallbadk(OnMapRenderCallback onMapRenderCallback) {
        this.s = onMapRenderCallback;
    }

    public final void setOnMapDoubleClickListener(OnMapDoubleClickListener onMapDoubleClickListener) {
        this.t = onMapDoubleClickListener;
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        this.u = onMapLongClickListener;
    }

    public final void setOnPolylineClickListener(OnPolylineClickListener onPolylineClickListener) {
        if (onPolylineClickListener != null) {
            this.w.add(onPolylineClickListener);
        }
    }

    public final void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        if (onMarkerClickListener != null && !this.v.contains(onMarkerClickListener)) {
            this.v.add(onMarkerClickListener);
        }
    }

    public final void setOnMarkerDragListener(OnMarkerDragListener onMarkerDragListener) {
        this.x = onMarkerDragListener;
    }

    public final void setOnMyLocationClickListener(OnMyLocationClickListener onMyLocationClickListener) {
        this.y = onMyLocationClickListener;
    }

    public final void setOnMapDrawFrameCallback(OnMapDrawFrameCallback onMapDrawFrameCallback) {
        this.A = onMapDrawFrameCallback;
    }

    public final void setOnBaseIndoorMapListener(OnBaseIndoorMapListener onBaseIndoorMapListener) {
        this.B = onBaseIndoorMapListener;
    }

    public final void setOnSynchronizationListener(OnSynchronizationListener onSynchronizationListener) {
        this.C = onSynchronizationListener;
    }

    public MapBaseIndoorMapInfo getFocusedBaseIndoorMapInfo() {
        return this.i.p();
    }

    public MapBaseIndoorMapInfo.SwitchFloorError switchBaseIndoorMapFloor(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.FLOOR_INFO_ERROR;
        }
        MapBaseIndoorMapInfo mapBaseIndoorMapInfo = this.getFocusedBaseIndoorMapInfo();
        if (null == mapBaseIndoorMapInfo) {
            return MapBaseIndoorMapInfo.SwitchFloorError.SWITCH_ERROR;
        }
        if (!string2.equals(mapBaseIndoorMapInfo.a)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.FOCUSED_ID_ERROR;
        }
        ArrayList<String> arrayList = mapBaseIndoorMapInfo.getFloors();
        if (arrayList == null || !arrayList.contains(string)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.FLOOR_OVERLFLOW;
        }
        if (this.i.a(string, string2)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.SWITCH_OK;
        }
        return MapBaseIndoorMapInfo.SwitchFloorError.SWITCH_ERROR;
    }

    public boolean isBaseIndoorMapMode() {
        return this.i.q();
    }

    public final void removeMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        if (this.v.contains(onMarkerClickListener)) {
            this.v.remove(onMarkerClickListener);
        }
    }

    public TileOverlay addTileLayer(TileOverlayOptions tileOverlayOptions) {
        if (tileOverlayOptions == null) {
            return null;
        }
        if (this.D != null) {
            this.D.b();
            this.D.a = null;
        }
        if (this.i != null && this.i.a(tileOverlayOptions.a())) {
            TileOverlay tileOverlay;
            this.D = tileOverlay = tileOverlayOptions.a(this);
            return tileOverlay;
        }
        return null;
    }

    public void hideSDKLayer() {
        this.i.c();
    }

    public void showSDKLayer() {
        this.i.d();
    }

    public void changeLocationLayerOrder(boolean bl) {
        this.i.c(bl);
    }

    public void setCompassEnable(boolean bl) {
        this.i.d(bl);
    }

    boolean b() {
        if (this.i == null) {
            return false;
        }
        return this.i.e();
    }

    void a(TileOverlay tileOverlay) {
        this.G.lock();
        try {
            if (tileOverlay != null && this.D == tileOverlay) {
                tileOverlay.b();
                tileOverlay.a = null;
                tileOverlay = null;
                if (this.i != null) {
                    this.i.e(false);
                }
            }
        }
        finally {
            this.D = null;
            this.G.unlock();
        }
    }

    public float[] getProjectionMatrix() {
        if (null == this.i) {
            return null;
        }
        return this.i.N();
    }

    public float[] getViewMatrix() {
        if (null == this.i) {
            return null;
        }
        return this.i.O();
    }

    static /* synthetic */ List a(BaiduMap baiduMap) {
        return baiduMap.k;
    }

    static /* synthetic */ e b(BaiduMap baiduMap) {
        return baiduMap.i;
    }

    static /* synthetic */ List c(BaiduMap baiduMap) {
        return baiduMap.m;
    }

    static /* synthetic */ List d(BaiduMap baiduMap) {
        return baiduMap.l;
    }

    static /* synthetic */ View e(BaiduMap baiduMap) {
        return baiduMap.J;
    }

    static /* synthetic */ OnMapStatusChangeListener f(BaiduMap baiduMap) {
        return baiduMap.o;
    }

    static /* synthetic */ OnSynchronizationListener g(BaiduMap baiduMap) {
        return baiduMap.C;
    }

    static /* synthetic */ OnMapTouchListener h(BaiduMap baiduMap) {
        return baiduMap.p;
    }

    static /* synthetic */ OnMapClickListener i(BaiduMap baiduMap) {
        return baiduMap.q;
    }

    static /* synthetic */ OnMapDoubleClickListener j(BaiduMap baiduMap) {
        return baiduMap.t;
    }

    static /* synthetic */ OnMapLongClickListener k(BaiduMap baiduMap) {
        return baiduMap.u;
    }

    static /* synthetic */ Projection a(BaiduMap baiduMap, Projection projection) {
        baiduMap.f = projection;
        return baiduMap.f;
    }

    static /* synthetic */ boolean a(BaiduMap baiduMap, boolean bl) {
        baiduMap.Q = bl;
        return baiduMap.Q;
    }

    static /* synthetic */ OnMapLoadedCallback l(BaiduMap baiduMap) {
        return baiduMap.r;
    }

    static /* synthetic */ OnMapRenderCallback m(BaiduMap baiduMap) {
        return baiduMap.s;
    }

    static /* synthetic */ SnapshotReadyCallback n(BaiduMap baiduMap) {
        return baiduMap.z;
    }

    static /* synthetic */ OnMyLocationClickListener o(BaiduMap baiduMap) {
        return baiduMap.y;
    }

    static /* synthetic */ InfoWindow p(BaiduMap baiduMap) {
        return baiduMap.H;
    }

    static /* synthetic */ Marker q(BaiduMap baiduMap) {
        return baiduMap.I;
    }

    static /* synthetic */ CopyOnWriteArrayList r(BaiduMap baiduMap) {
        return baiduMap.v;
    }

    static /* synthetic */ CopyOnWriteArrayList s(BaiduMap baiduMap) {
        return baiduMap.w;
    }

    static /* synthetic */ Marker t(BaiduMap baiduMap) {
        return baiduMap.K;
    }

    static /* synthetic */ Projection u(BaiduMap baiduMap) {
        return baiduMap.f;
    }

    static /* synthetic */ OnMarkerDragListener v(BaiduMap baiduMap) {
        return baiduMap.x;
    }

    static /* synthetic */ Marker a(BaiduMap baiduMap, Marker marker) {
        baiduMap.K = marker;
        return baiduMap.K;
    }

    static /* synthetic */ Lock w(BaiduMap baiduMap) {
        return baiduMap.F;
    }

    static /* synthetic */ HeatMap x(BaiduMap baiduMap) {
        return baiduMap.E;
    }

    static /* synthetic */ OnMapDrawFrameCallback y(BaiduMap baiduMap) {
        return baiduMap.A;
    }

    static /* synthetic */ OnBaseIndoorMapListener z(BaiduMap baiduMap) {
        return baiduMap.B;
    }

    static /* synthetic */ Lock A(BaiduMap baiduMap) {
        return baiduMap.G;
    }

    static /* synthetic */ TileOverlay B(BaiduMap baiduMap) {
        return baiduMap.D;
    }

    public static interface OnSynchronizationListener {
        public void onMapStatusChangeReason(int var1);
    }

    public static interface OnBaseIndoorMapListener {
        public void onBaseIndoorMapMode(boolean var1, MapBaseIndoorMapInfo var2);
    }

    public static interface OnMapDrawFrameCallback {
        @Deprecated
        public void onMapDrawFrame(GL10 var1, MapStatus var2);

        public void onMapDrawFrame(MapStatus var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface OnMyLocationClickListener {
        public boolean onMyLocationClick();
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);

        public void onMarkerDragStart(Marker var1);
    }

    public static interface OnPolylineClickListener {
        public boolean onPolylineClick(Polyline var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapDoubleClickListener {
        public void onMapDoubleClick(LatLng var1);
    }

    public static interface OnMapRenderCallback {
        public void onMapRenderFinished();
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);

        public boolean onMapPoiClick(MapPoi var1);
    }

    public static interface OnMapTouchListener {
        public void onTouch(MotionEvent var1);
    }

    public static interface OnMapStatusChangeListener {
        public static final int REASON_GESTURE = 1;
        public static final int REASON_API_ANIMATION = 2;
        public static final int REASON_DEVELOPER_ANIMATION = 3;

        public void onMapStatusChangeStart(MapStatus var1);

        public void onMapStatusChangeStart(MapStatus var1, int var2);

        public void onMapStatusChange(MapStatus var1);

        public void onMapStatusChangeFinish(MapStatus var1);
    }
}

