package com.rv.share.adapter;

import android.support.annotation.Nullable;

import com.base.utils.ui.image.round.RoundImageView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.component.utils.DateUtils;
import com.rv.share.R;
import com.rv.share.bean.InviteListBean;
import com.rv.share.view.MyTimerView;

import java.util.List;

public class InviteListAdapter extends BaseQuickAdapter<InviteListBean.inviteMember, BaseViewHolder> {

    private long effTime = 0L;

    public InviteListAdapter(@Nullable List<InviteListBean.inviteMember> data) {
        super(R.layout.item_invite, data);
    }

    public void setEffTime(long effTime) {
        this.effTime = effTime;
    }

    @Override
    protected void convert(BaseViewHolder helper, InviteListBean.inviteMember item) {
        helper.setText(R.id.tv_income_record, item.getUsername());
        helper.setText(R.id.tv_income_time, DateUtils.timestampToString1(item.getJoinTime()));

        setTimes(effTime, helper, item);

        GlideManager.getInstance(mContext).loadImage(item.getHeadUrl(), (RoundImageView) helper.itemView.findViewById(R.id.rimg_header));
    }

    private void setTimes(long effTime, BaseViewHolder helper, InviteListBean.inviteMember bean) {
        if (bean != null) {
            long crtTime = bean.getJoinTime();
            long remain = effTime - (System.currentTimeMillis() - crtTime);
            if (remain <= 0) {
                getData().remove(bean);
                notifyDataSetChanged();
            } else {
                ((MyTimerView) helper.itemView.findViewById(com.rv.home.R.id.tv_remain_time)).setTime(effTime, bean.getJoinTime(), timerListener);
            }
        }
    }

    public MyTimerView.TimerListener timerListener = new MyTimerView.TimerListener() {
        @Override
        public void onTimeFinish() {
            notifyDataSetChanged();
        }
    };
}
