package com.rv.share.adapter;

import android.support.annotation.Nullable;
import android.widget.TextView;

import com.base.utils.ui.image.round.RoundImageView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.component.utils.DateUtils;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;
import com.rv.share.R;
import com.rv.share.bean.IncomeRecordsBean;

import java.util.ArrayList;
import java.util.List;

public class IncomeListAdapter extends BaseQuickAdapter<IncomeRecordsBean.IncomeItem, BaseViewHolder> {

    public IncomeListAdapter(@Nullable List<IncomeRecordsBean.IncomeItem> data) {
        super(R.layout.item_income, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, IncomeRecordsBean.IncomeItem item) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(item.getUsername()).append("成交").append(item.getPrice()).append("元");
        helper.setText(R.id.tv_income_record, buffer.toString());

        helper.setText(R.id.tv_income_time, DateUtils.timestampToString1(item.getCrtTime()));

        StringBuilder builder = new StringBuilder();
        builder.append("+").append(item.getCommission()).append("元");
        helper.setText(R.id.tv_income_price, builder.toString());

        GlideManager.getInstance(mContext).loadImage(item.getHeadUrl(), (RoundImageView) helper.itemView.findViewById(R.id.rimg_header));
    }
}
