package com.rv.points;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.frame.rv.config.RvFrameConfig;
import com.google.gson.Gson;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.points.bean.SignRecordBean;
import com.rv.points.bean.SignResultBean;
import com.rv.points.adapter.DateAdapter;
import com.rv.points.utils.DateUtils;
import com.rv.points.view.InnerGridView;
import com.yuyife.okgo.OkGoUtil;

import java.util.HashMap;
import java.util.Map;

import butterknife.BindView;

public class SignActivity extends BaseStatusActivity<CommonPresenter> {

    @BindView(R2.id.btn_sign)
    Button btnSign;
    @BindView(R2.id.view_month)
    InnerGridView innerGridView;
    @BindView(R2.id.tv_sign_day)
    TextView tvSignDay;
    private DateAdapter dateAdapter;

    @Override
    protected int setLayout() {
        return R.layout.activity_sign;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("签到");
        btnSign.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                sign();
            }
        });
        dateAdapter = new DateAdapter(this);
        innerGridView.setAdapter(dateAdapter);
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        getSignList();
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        if (requestType == 0) {
            SignRecordBean bean = (SignRecordBean) result;
            if (bean.getData() != null && bean.getData().size() > 0) {
                tvSignDay.setText("你已累计签到" + bean.getData().size() + "天");
                dateAdapter.setSignData(bean.getData());
            }
        }
        if (requestType == 1) {
            Toast.makeText(getApplicationContext(), "签到成功", Toast.LENGTH_SHORT).show();
            getSignList();
        }
    }

    private void getSignList() {
        if (!TextUtils.isEmpty(OkGoUtil.getToken()) || 1 == 1) {
            Map<String, Object> header = new HashMap<>();
            header.put("Authorization", OkGoUtil.getToken());

            Map<String, Object> map = new HashMap<>();
            map.put("startTime", DateUtils.getBeginTime());
            map.put("endTime", DateUtils.getEndTime());
            map.put("integralRuleCode", "SIGN");
            mPresenter.getData(RvFrameConfig.HOST, 0, ApiConfig.HTTP_URL_SIGN_LIST, SignRecordBean.class, map, header, true);
        }
    }

    /*****
     * 签到
     */
    private void sign() {
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            Map<String, Object> header = new HashMap<>();
            header.put("Authorization", OkGoUtil.getToken());

            Map<String,Object> body = new HashMap<>() ;
            body.put("integralRuleCode","SIGN") ;
            mPresenter.postData(RvFrameConfig.HOST ,1, ApiConfig.HTTP_URL_SIGN, SignResultBean.class, body, header, true);
        }
    }

}
