package com.rv.member;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.order.OrderDetailActivity;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;
import com.rv.member.adapter.ConsumeRecordListAdapter;
import com.rv.component.utils.Cache;
import com.rv.component.utils.CacheEnum;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import butterknife.BindView;

public class ConsumeRecordActivity extends BaseStatusActivity<CommonPresenter> implements SimpleRefreshLayout.OnSimpleRefreshListener, BaseQuickAdapter.RequestLoadMoreListener {

    @BindView(R2.id.refresh)
    SimpleRefreshLayout simpleRefreshLayout;
    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;

    private int mPage = 1;
    private int pageCount;
    private List<OrderListBean.DataBeanX.DataBean> lists = new ArrayList<>();

    private ConsumeRecordListAdapter adapter = null;

    @Override
    protected int setLayout() {
        return R.layout.activity_consume_record;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("消费记录");
        recyclerView.setLayoutManager(new LinearLayoutManager(mActivity));
        OrderListBean bean = (OrderListBean) Cache.getInstance(getApplicationContext()).get(CacheEnum.CONSUMER_RECORD);
        if (bean != null && bean.getData() != null && bean.getData().getData() != null) {
            lists.addAll(bean.getData().getData());
        }
        adapter = new ConsumeRecordListAdapter(lists, mClickListener);
        adapter.setEmptyView(getEmptyView(recyclerView, -1, getString(R.string.tv_no_consume_data)));
        adapter.setOnLoadMoreListener(this, recyclerView);
        recyclerView.setAdapter(adapter);
        simpleRefreshLayout.setHeaderView(new SimpleRefreshView(this));
//        simpleRefreshLayout.setFooterView(new SimpleLoadView(this), 100);
        simpleRefreshLayout.setOnSimpleRefreshListener(this);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

        lists.clear();
        if (requestType == 1) {   // 下拉刷新数据
            simpleRefreshLayout.onRefreshComplete();
        } else if (requestType == 2) {   // 上拉加载更多
            simpleRefreshLayout.onLoadMoreComplete();
        }
        OrderListBean listBean = (OrderListBean) result;
        Cache.getInstance(getApplicationContext()).save(listBean, CacheEnum.CONSUMER_RECORD);
        if (listBean != null && listBean.getData() != null) {
            pageCount = listBean.getData().getTotalPage();
            lists.addAll(listBean.getData().getData());
            adapter.notifyDataSetChanged();
        }
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        getConsumeRecordData(0);
    }

    private void getConsumeRecordData(int position) {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        Map<String, Object> bodyMap = new LinkedHashMap<>();
        bodyMap.put("page", mPage);
        bodyMap.put("limit", 10);
//        bodyMap.put("status", "3");
        bodyMap.put("hasMemberRight", 1);
        bodyMap.put("type", 1);
        bodyMap.put("multiStatus", "3,4,5,6");
        mPresenter.getData(RvFrameConfig.VEHICLE_ORDER, position, ApiConfig.HTTP_URL_ORDER_LIST, OrderListBean.class, bodyMap, headMap, mPage == 1 ? true : false);
    }

    private ConsumeRecordListAdapter.ConsumeListener mClickListener = new ConsumeRecordListAdapter.ConsumeListener() {
        @Override
        public void click(OrderListBean.DataBeanX.DataBean bean) {
            if (bean != null) {
                startActivity(OrderDetailActivity.getIntent(ConsumeRecordActivity.this, bean));
            }
        }
    };

    @Override
    public void onRefresh() {
        mPage = 1;
        getConsumeRecordData(1);
    }

    @Override
    public void onLoadMoreRequested() {
        if (mPage >= pageCount) {
            adapter.loadMoreEnd();
        } else {
            mPage += 1;
            getConsumeRecordData(2);
        }
    }
}
