package com.rv.home.rv.module.ui.main.home.adapter;

import android.text.TextUtils;

import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.basic.bean.MultiItemBean;
import com.rv.home.rv.module.ui.main.home.bean.CityHeadBean;
import com.rv.home.rv.module.ui.main.home.bean.HotCityBean;
import com.rv.home.rv.module.ui.main.home.bean.ListsBean;

import java.util.List;

/**
 * Created :Auser
 * Date: 2019/5/11.
 * Desc:城市列表Adapter
 */

public class CityListAdapter extends BaseMultiItemQuickAdapter<MultiItemBean, BaseViewHolder> {
    public static final int TYPE_INDEX_HEAD = 1;
    public static final int TYPE_INDEX_HOT = 2;
    public static final int TYPE_INDEX_CITY = 3;


    public CityListAdapter(List<MultiItemBean> data) {
        super(data);
        addItemType(TYPE_INDEX_HEAD, R.layout.rv_item_head);
        addItemType(TYPE_INDEX_HOT, R.layout.rv_item_hot_city);
        addItemType(TYPE_INDEX_CITY, R.layout.rv_item_city);
    }

    @Override
    protected void convert(BaseViewHolder helper, MultiItemBean item) {
        switch (helper.getItemViewType()) {
            case TYPE_INDEX_HEAD:
                CityHeadBean cityHeadBean = (CityHeadBean) item;
                helper.setText(R.id.tv_head, cityHeadBean.headName);
                break;
            case TYPE_INDEX_HOT:
                HotCityBean hotCityBean = (HotCityBean) item;
                helper.setText(R.id.tv_hot_city, hotCityBean.hotCityName);
                break;
            case TYPE_INDEX_CITY:
                ListsBean cityBean = (ListsBean) item;
                helper.setText(R.id.tv_city, cityBean.getName());
                break;
        }
    }

    public  int getSelectIndex(String an){
        if(an.equals("定位")||an.equals("热门")){
            return 0;
        }

        if(TextUtils.isEmpty(an)){
            return -1;
        }
        for(MultiItemBean bean:getData()){
            if(bean.getItemType()==TYPE_INDEX_HEAD){
              CityHeadBean headBean= (CityHeadBean) bean;
              if(headBean.headName.equals(an)){
                  return  getData().indexOf(bean);
              }
            }
        }

        return -1;
    }
}
