package com.frame.rv.widget;

import android.content.Context;
import android.media.Image;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.frame.rv.R;

public class BaseTitleBarLayout extends RelativeLayout {
    public BaseTitleBarLayout(Context context) {
        super(context);
        init(context);

    }

    public BaseTitleBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);

    }

    public BaseTitleBarLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private ImageView backImageView;
    private TextView titleTextView;
    private TextView buttonView;
    public ImageView buttonCollect;
    public ImageView buttonShare;

    private void init(Context context) {

        View view = LayoutInflater.from(context).inflate(R.layout.layout_title, this, true);
        backImageView = view.findViewById(R.id.title_bar_back_image_view);
        titleTextView = view.findViewById(R.id.title_bar_text_view);
        buttonView = view.findViewById(R.id.title_bar_button_view);
        buttonCollect = view.findViewById(R.id.iv_collect);
        buttonShare = view.findViewById(R.id.iv_share);
        buttonView.setVisibility(GONE);
        buttonCollect.setVisibility(GONE);
        buttonShare.setVisibility(GONE);
    }

    public void setButtonShare(OnClickListener listener){
        buttonShare.setVisibility(VISIBLE);
        buttonShare.setOnClickListener(listener);
    }

    public void setButtonCollect(OnClickListener listener){
        buttonCollect.setVisibility(VISIBLE);
        buttonCollect.setOnClickListener(listener);
    }

    public void setButtonView(String text,OnClickListener listener) {
        buttonView.setVisibility(VISIBLE);
        buttonView.setText(text);
        buttonView.setOnClickListener(listener);
    }
    public void setBackClickListener(OnClickListener listener) {
        if (listener==null){
            setBackVisibility(GONE);
        }else {
            backImageView.setOnClickListener(listener);
        }
    }

    public void setBackVisibility(int visibility) {
        backImageView.setVisibility(visibility);
    }

    public void setTitleText(String text) {
        titleTextView.setText(text);
    }
}
