package com.xxfc.rv.wxapi;


import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

import com.frame.base.bus.PaymentFailedEvent;
import com.frame.base.bus.PaymentSuccessfulEvent;
import com.frame.base.bus.RxBus;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.weight.TitleView;

import com.rv.home.R2;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.order.OrderListActivity;
import com.tencent.mm.opensdk.constants.ConstantsAPI;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import com.xxfc.rv.R;

import butterknife.BindView;
import butterknife.OnClick;


public class WXPayEntryActivity extends BaseStatusActivity<CommonPresenter> implements IWXAPIEventHandler {

    private static final String TAG = "MicroMsg.SDKSample.WXPayEntryActivity";
    @BindView(R2.id.tv_content)
    TextView tvContent;
    @BindView(R2.id.tv_order)
    TextView tvOrder;

    private IWXAPI api;

    private int payResult;

    @Override
    protected int setLayout() {
        return R.layout.rv_pay_result;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle(mActivity.getString(R.string.rv_weixin_pay_success));
        api = WXAPIFactory.createWXAPI(this, RvFrameConfig.APP_ID);
        api.handleIntent(getIntent(), this);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        setIntent(intent);
        api.handleIntent(intent, this);
    }

    @Override
    public void onReq(BaseReq req) {
    }

    @Override
    public void onResp(BaseResp resp) {
        payResult = resp.errCode;
        Log.d("Wxpayentryactivity", "onPayFinish, errCode = " + resp.errCode);
        if (resp.getType() == ConstantsAPI.COMMAND_PAY_BY_WX) {
            switch (resp.errCode) {
                case 0:
                    // 支付成功
                    break;
                case -1:
                    finish();
                    break;
                case -2:
                    RxBus.post(new PaymentFailedEvent());
                    finish();
                    break;
            }
        }
    }


    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }


    @OnClick(R2.id.tv_order)
    public void onViewClicked() {
//        startActivity(OrderListActivity.getIntent(mActivity, 1));
        finish();
    }


    @Override
    public void finish() {
        if (payResult == 0) {
            RxBus.post(new PaymentSuccessfulEvent());
        }
        super.finish();
    }
}