/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import java.util.List;

public class CommonUtil {
    public static boolean checkPath(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean checkAndroidManifest(Context context, String string) {
        try {
            ComponentName componentName = new ComponentName(context.getPackageName(), string);
            PackageManager packageManager = context.getPackageManager();
            packageManager.getActivityInfo(componentName, 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public static boolean checkPermission(Context context, String string) {
        PackageManager packageManager = context.getPackageManager();
        return 0 == packageManager.checkPermission(string, context.getPackageName());
    }

    public static boolean checkIntentFilterData(Context context, String string) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addCategory("android.intent.category.BROWSABLE");
        String string2 = "tencent" + string + ":";
        Uri uri = Uri.parse((String)string2);
        intent.setData(uri);
        List list = context.getPackageManager().queryIntentActivities(intent, 64);
        if (list.size() > 0) {
            for (ResolveInfo resolveInfo : list) {
                if (resolveInfo.activityInfo == null || !resolveInfo.activityInfo.packageName.equals(context.getPackageName())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean checkResource(Context context, String string, String string2) {
        int n = context.getResources().getIdentifier(string, string2, context.getPackageName());
        return n > 0;
    }

    public static boolean checkMetaData(Context context, String string) {
        PackageManager packageManager = context.getPackageManager();
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null) {
                Object object = applicationInfo.metaData.get(string);
                return object != null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static String checkKeyHash(Context context) {
        return "";
    }

    public static String checkMD5Sign(Context context) {
        return "";
    }

    public static String checkSHA1(Context context) {
        return "";
    }
}

