package com.rv.rvmine.traveler;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.util.UtilsManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.login.RegisteredActivity;
import com.rv.rvmine.R;
import com.rv.rvmine.R2;
import com.yuyife.okgo.OkGoUtil;

import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * 设置
 */

public class SettingActivity extends BaseStatusActivity<CommonPresenter> {

    @Override
    protected int setLayout() {
        return R.layout.activity_setting;
    }


    public static Intent getIntent(Context context) {
        return new Intent(context, SettingActivity.class);
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle(getString(R.string.setting_title));
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ButterKnife.bind(this);
    }

    @OnClick({R2.id.rl_item_change_password,R2.id.ll_item_app_push,R2.id.rl_item_clear_cache,R2.id.rl_item_check_for_updates,R2.id.rl_item_about_us,R2.id.tv_out_sign})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.rl_item_change_password){
            //修改密码
            startActivity(RegisteredActivity.getIntent(mActivity, 1));

        }else if (id == R.id.ll_item_app_push){
            //App推送消息

        }else if (id == R.id.rl_item_clear_cache){
            //清除缓存

        }else if (id == R.id.rl_item_check_for_updates){
            //检查更新

        }else if (id ==  R.id.rl_item_about_us){
            //关于我们
            startActivity(AboutUsActivity.getIntent(mActivity));

        }else if (id == R.id.tv_out_sign){
            //退出登录
            UtilsManager.getInstance(mActivity).clearShareData("city_json");
            UtilsManager.getInstance(mActivity).setShNull();
            OkGoUtil.clearToken();
            setResult(201);
            showToast("退出成功！");
            finish();
        }
    }
}
