package com.rv.rvmine.traveler;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.url.Constance;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.rvmine.R2;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.rvmine.R;
import com.rv.rvmine.adapter.TravelerListAdapter;
import com.rv.rvmine.bean.TravelerListBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;

/**
 * 选择出游人
 */
@Route(path = Constance.ACTIVITY_URL_CHOOSEAVISITOR)
public class ChooseAVisitorActivity extends BaseStatusActivity<CommonPresenter> {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;

    private TravelerListAdapter mAdapter;
    private final int TYPE_REQUEST_ADD = 105;
    private final int TYPE_REQUEST_EDIT = 2;
    private int mPage;
    private int countPage;

    public static Intent getIntent(Context context) {
        return new Intent(context, ChooseAVisitorActivity.class);
    }


    @Override
    protected int setLayout() {
        return R.layout.activity_choose_avisitor;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("选择出游人");
        titleView.setImageResource(R.id.iv_title_right, R.drawable.rv_common_icon_thestaff);
        titleView.setChildClickListener(R.id.iv_title_right, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivityForResult(AddAVisitorActivity.getIntent(mActivity, null), TYPE_REQUEST_ADD);
            }
        });


        mAdapter = new TravelerListAdapter();
        recyclerView.setLayoutManager(new LinearLayoutManager(mActivity));
        recyclerView.setAdapter(mAdapter);
        mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                TravelerListBean.DataBean item = mAdapter.getItem(position);
                Intent intent1 = getIntent();
                intent1.putExtra("name", item.getName());
                intent1.putExtra("phone", item.getPhone());
                intent1.putExtra("idcard", item.getIdCard());
                intent1.putExtra("id", item.getId());
                setResult(RESULT_OK, intent1);
                finish();
            }
        });

        mAdapter.setOnItemChildClickListener(new BaseQuickAdapter.OnItemChildClickListener() {
            @Override
            public void onItemChildClick(BaseQuickAdapter adapter, View view, int position) {
                if (view.getId() == R.id.tv_edit) {
                    startActivityForResult(AddAVisitorActivity.getIntent(mActivity, mAdapter.getItem(position)), TYPE_REQUEST_ADD);
                }
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        getDrivingList();
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        processData((TravelerListBean) result);
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == TYPE_REQUEST_ADD && resultCode == RESULT_OK) {
            getDrivingList();
        }
    }

    /**
     *
     */
    private void getDrivingList() {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        mPresenter.getDataHead(RvFrameConfig.VEHICLE_TOURUSER, 0, ApiConfig.HTTP_URL_GETTOURUSERLIST, TravelerListBean.class, headMap, true);
    }


    private void processData(TravelerListBean bean) {
        if (bean.getData() == null || bean.getData().size() == 0) {
            mAdapter.setEmptyView(getEmptyView(recyclerView, -1, "您还没有出游人信息哦"));
            return;
        }
        mAdapter.setNewData(bean.getData());
    }

}
