package com.rv.home.rv.module.ui.main.home.adapter;


import android.widget.RelativeLayout;
import android.widget.TextView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.rv.home.R;
import com.rv.home.rv.module.ui.main.home.bean.HomePopularBrigade;


/**
 * 房车游榜单  标注
 */
public class RVTourListLabelAdapter extends BaseQuickAdapter<HomePopularBrigade.DataBean, BaseGlideHolder> {

    private int selectPosition;

    public RVTourListLabelAdapter() {
        super(R.layout.rv_item_rv_tourlist_label);
    }

    @Override
    protected void convert(BaseGlideHolder helper, HomePopularBrigade.DataBean bean) {
        helper.setText(R.id.tv_rvtour_label, bean.getName());
        TextView label = (TextView) helper.getView(R.id.tv_rvtour_label);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) label.getLayoutParams();
        if (selectPosition == mData.indexOf(bean)) {
            layoutParams.width = 200;
            layoutParams.height =  90;
            label.setLayoutParams(layoutParams);
            label.setTextColor(mContext.getResources().getColor(R.color.colorMain));
//            label.setWidth(R.dimen.size_90);
//            label.setHeight(R.dimen.size_50);
        } else {
//            helper.setChecked(R.id.rg_check,false);
//            label.setWidth(R.dimen.size_70);
//            label.setHeight(R.dimen.size_30);
            layoutParams.width = 140;
            layoutParams.height = 70;
            label.setLayoutParams(layoutParams);
            label.setTextColor(mContext.getResources().getColor(R.color.textGray));
        }

    }

    public void setSelectPosition(int position) {
        this.selectPosition = position;
        notifyDataSetChanged();
    }
}
