package com.rv.home.rv.module.ui.main.home.adapter;

import android.support.v4.content.ContextCompat;

import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.basic.bean.MultiItemBean;
import com.rv.home.rv.module.ui.main.home.bean.CarAttributeListBean;

import java.util.List;

/**
 * Created :Auser
 * Date: 2019/5/16.
 * Desc:属性列表Adapter
 */

public class AttributeListAdapter extends BaseMultiItemQuickAdapter<MultiItemBean, BaseViewHolder> {
    public static final int TYPE_ATTRIBUTE_TYPE = 1;
    public static final int TYPE_ATTRIBUTE_NAME = 2;


    public AttributeListAdapter(List<MultiItemBean> data) {
        super(data);
        addItemType(TYPE_ATTRIBUTE_TYPE, R.layout.rv_item_car_attr);
        addItemType(TYPE_ATTRIBUTE_NAME, R.layout.rv_item_car_attr_name);
    }

    @Override
    protected void convert(BaseViewHolder helper, MultiItemBean item) {
        switch (helper.getItemViewType()) {
            case TYPE_ATTRIBUTE_TYPE:
                CarAttributeListBean.DataBean.CataBean typeBean = (CarAttributeListBean.DataBean.CataBean) item;
                helper.setText(R.id.tv_type_name, typeBean.getName());
                break;
            case TYPE_ATTRIBUTE_NAME:
                CarAttributeListBean.DataBean.CataBean.ChildrenBean nameBean = (CarAttributeListBean.DataBean.CataBean.ChildrenBean) item;
                helper.setText(R.id.tv_attr_name, nameBean.getName());
                if (nameBean.isSelect == 1) {
                    helper.setBackgroundRes(R.id.rl_bg, R.drawable.rv_rentingcar_icon_select_triangle);
                    helper.setTextColor(R.id.tv_attr_name, ContextCompat.getColor(mContext, R.color.colorAuxiliaryYellow));
//                       helper.setGone(R.id.iv_select, true);
                } else {
                    helper.setBackgroundRes(R.id.rl_bg, R.drawable.shape_rv_line_bg);
                    helper.setTextColor(R.id.tv_attr_name, ContextCompat.getColor(mContext, R.color.textMain));
//                    helper.setGone(R.id.iv_select, false);
                }
                break;

        }
    }


    /**
     * 设置Item选中事件
     *
     * @param position
     */
    public void setItemSelect(int position) {
        if (getData().get(position) instanceof CarAttributeListBean.DataBean.CataBean.ChildrenBean) {
            CarAttributeListBean.DataBean.CataBean.ChildrenBean bean = (CarAttributeListBean.DataBean.CataBean.ChildrenBean) getData().get(position);
            bean.isSelect = bean.isSelect == 0 ? 1 : 0;
            getData().set(position, bean);
            notifyItemChanged(position);
        }

    }

    /**
     * 获取选中的Id
     *
     * @return
     */
    public List<Integer> getSelectId(List<Integer> list) {

        for (MultiItemBean bean : mData) {
            if (bean instanceof CarAttributeListBean.DataBean.CataBean.ChildrenBean) {
                CarAttributeListBean.DataBean.CataBean.ChildrenBean childrenBean = (CarAttributeListBean.DataBean.CataBean.ChildrenBean) bean;
                if (childrenBean.isSelect == 1) {
                    list.add(childrenBean.getId());
                }
            }
        }
        return list;
    }


    public void resetData() {
        for (MultiItemBean bean : mData) {
            if (bean instanceof CarAttributeListBean.DataBean.CataBean.ChildrenBean) {
                CarAttributeListBean.DataBean.CataBean.ChildrenBean childrenBean = (CarAttributeListBean.DataBean.CataBean.ChildrenBean) bean;
                childrenBean.isSelect = 0;
            }
        }
        notifyDataSetChanged();
    }

}
