package com.rv.home.rv.module.ui.login;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.util.listener.TextChangedListener;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.BaseLoginActivity;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.login.bean.RegisteredBean;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.utils.SocializeUtils;

import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;
import butterknife.OnClick;


public class PwdLoginActivity extends BaseLoginActivity<CommonPresenter> {

    @BindView(R2.id.et_phone)
    EditText etPhone;
    @BindView(R2.id.iv_clear_phone)
    ImageView ivClearPhone;
    @BindView(R2.id.et_pwd)
    EditText etPwd;
    @BindView(R2.id.iv_clear_pwd)
    ImageView ivClearPwd;
    @BindView(R2.id.tv_login)
    TextView tvLogin;

    private boolean isShow;

    public static Intent getIntent(Context context) {
        return new Intent(context, PwdLoginActivity.class);
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        super.initView(savedInstanceState, titleView, intent);
        titleView.setTitle(mActivity.getString(R.string.rv_pwd_login));
        editListener(etPhone);
        editListener(etPwd);
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }

    @Override
    protected int setLayout() {
        return R.layout.rv_act_pwd_login;
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        if (requestType == 0) {
            processLoginData((RegisteredBean) result);
        }
    }

    @OnClick({R2.id.iv_clear_phone, R2.id.iv_clear_pwd, R2.id.tv_login, R2.id.tv_phone_login, R2.id.tv_registered, R2.id.iv_weixin, R2.id.iv_qq, R2.id.tv_forget_pwd})
    public void onViewClicked(View view) {

        if(view.getId()==R.id.iv_clear_phone){
            clearEditData(etPhone);
        }else  if(view.getId()==R.id.iv_clear_pwd){
            isShow=!isShow;
            ivClearPwd.setSelected(isShow);
            etPwd.setTransformationMethod(isShow?HideReturnsTransformationMethod.getInstance(): PasswordTransformationMethod.getInstance());
        }else  if(view.getId()==R.id.tv_login){
            if (getPwd().length() < 8) {
                showToast(mActivity.getString(R.string.rv_pwd_length));
                return;
            }
            pwdLogin();
        }else  if(view.getId()==R.id.tv_phone_login){
            finish();
        }else  if(view.getId()==R.id.tv_registered){
            startActivity(RegisteredActivity.getIntent(mActivity, 0));
            finish();
        }else  if(view.getId()==R.id.iv_weixin){
            umLogin(SHARE_MEDIA.WEIXIN);
        }else  if(view.getId()==R.id.iv_qq){
            umLogin(SHARE_MEDIA.QQ);
        }else  if(view.getId()==R.id.tv_forget_pwd){
            startActivity(RegisteredActivity.getIntent(mActivity, 1));
            finish();
        }

//
//
//        switch (view.getId()) {
//            case R.id.iv_clear_phone:
//                clearEditData(etPhone);
//                break;
//            case R.id.iv_clear_pwd:
//                isShow=!isShow;
//                ivClearPwd.setSelected(isShow);
//                etPwd.setTransformationMethod(isShow?HideReturnsTransformationMethod.getInstance(): PasswordTransformationMethod.getInstance());
////                clearEditData(etPwd);
//                break;
//            case R.id.tv_login://密码登录
////                if(TextUtils.isEmpty(getPhone())){
////                showToast(mActivity.getString(R.string.rv_phone_hint));
////                return;
////                }
////                if(TextUtils.isEmpty(getPwd())){
////                    showToast(mActivity.getString(R.string.rv_pwd_hint));
////                    return;
////                }
//                if (getPwd().length() < 8) {
//                    showToast(mActivity.getString(R.string.rv_pwd_length));
//                    return;
//                }
//                pwdLogin();
//                break;
//            case R.id.tv_phone_login://手机登录
//                finish();
//                break;
//            case R.id.tv_registered://立即注册
//                startActivity(RegisteredActivity.getIntent(mActivity, 0));
//                finish();
//                break;
//            case R.id.iv_weixin:
//                umLogin(SHARE_MEDIA.WEIXIN);
//                break;
//            case R.id.iv_qq:
//                umLogin(SHARE_MEDIA.QQ);
//                break;
//            case R.id.tv_forget_pwd:
//                startActivity(RegisteredActivity.getIntent(mActivity, 1));
//                finish();
//                break;
//        }
    }

    /**
     * 获得手机号
     *
     * @return
     */
    private String getPhone() {
        return etPhone.getText().toString().trim();
    }

    /**
     * 获得验证码
     *
     * @return
     */
    private String getPwd() {
        return etPwd.getText().toString().trim();
    }

    /**
     * 清除编辑数据
     */
    private void clearEditData(EditText text) {
        text.setText("");
    }

    /**
     * 登录成功回调
     *
     * @param share_media
     * @param i
     * @param map
     */
    @Override
    public void onComplete(SHARE_MEDIA share_media, int i, Map<String, String> map) {
        if (dialog != null) {
            SocializeUtils.safeCloseDialog(dialog);
        }
        showToast(mActivity.getString(R.string.rv_login_success));
    }

    /**
     * 文本输入监听
     *
     * @param editText
     */
    private void editListener(final EditText editText) {
        editText.addTextChangedListener(new TextChangedListener() {
            @Override
            public void afterTextChanged(Editable s) {
                super.afterTextChanged(s);
                if(editText.getId()==R.id.et_phone){
                    ivClearPhone.setVisibility(getPhone().length() > 0 ? View.VISIBLE : View.GONE);
                }else if(editText.getId()==R.id.et_phone_code){

                }
//                switch (editText.getId()) {
//                    case R.id.et_phone:
//                        ivClearPhone.setVisibility(getPhone().length() > 0 ? View.VISIBLE : View.GONE);
//                        break;
//                    case R.id.et_phone_code:
//
//                        break;
//                }
                if (etPhone.length() > 0 && etPwd.length() > 0) {
                    tvLogin.setEnabled(true);
                    tvLogin.setSelected(true);
                } else {
                    tvLogin.setEnabled(false);
                    tvLogin.setSelected(false);
                }


            }
        });
    }


    /**
     * 验证码登录
     */
    private void pwdLogin() {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("username", getPhone());
        map.put("password", getPwd());
        map.put("type", 1);
        mPresenter.postData(0, ApiConfig.HTTP_URL_PWD_LOGIN, RegisteredBean.class, map, true);
    }

    public class PwdLoginBean {

        private String username;
        private String password;

        public PwdLoginBean(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getPassword() {
            return password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getUsername() {
            return username;
        }

        public void setUsername(String username) {
            this.username = username;
        }
    }
}
