package com.rv.home.rv.module.basic;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.widget.LinearLayout;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.webview.SafeWebView;
import com.rv.home.R;
import com.rv.home.rv.module.basic.presenter.PickerPresenter;
import com.rv.home.R2;
import butterknife.BindView;

public class WebActivity extends BaseStatusActivity<PickerPresenter> {

    @BindView(R2.id.webView)
    SafeWebView mWebView;
    @BindView(R2.id.lay_web)
    LinearLayout mRoot;

    public static Intent getIntent(Context context, String title, String url) {
        return new Intent(context, WebActivity.class).putExtra("title", title).putExtra("url", url);
    }


    @Override
    protected int setLayout() {
        return R.layout.rv_activity_web;
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle(intent.getStringExtra("title"));
        String url = intent.getStringExtra("url");
        mWebView.loadUrl(url);
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }



    @Override
    public void onResume() {
        super.onResume();
        mWebView.onResume();
        mWebView.resumeTimers();
    }

    @Override
    protected void onPause() {
        super.onPause();
        mWebView.onPause();
        mWebView.pauseTimers();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (mRoot != null) {
            mRoot.removeView(mWebView);
        }
        if (mWebView != null) {
            mWebView.stopLoading();
            mWebView.clearMatches();
            mWebView.clearHistory();
            mWebView.clearSslPreferences();
            mWebView.clearCache(true);
            mWebView.loadUrl("about:blank");
            mWebView.removeAllViews();
            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR2) {
                mWebView.removeJavascriptInterface("AndroidNative");
            }
            mWebView.destroy();
        }
        mWebView = null;
    }


}
