package com.xxrv.wallet.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.LinearLayout;

import com.xxrv.wallet.R;
import com.xxrv.wallet.view.PayPassView;
import com.xxrv.wallet.view.SetPayPassView;

/**
 * 使用弹框作为容器
 */

public class SetPasswordDialog {
    private AlertDialog mDialog;//弹框
    private Window window;//窗口
    private Context mContext;//上下文
    private int mThemeResId;//主题
    private View mDialogLayout;//布局


    /**
     * 默认样式
     * @param context
     */
    public SetPasswordDialog(Context context) {

        this.mContext = context;
        this.mThemeResId= R.style.dialog_pay_theme;
        this.mDialogLayout =  LayoutInflater.from(mContext).inflate(R.layout.view_set_pay_pwd_dialog,null);
        mDialog=new AlertDialog.Builder(mContext,mThemeResId).create();
        mDialog.setCancelable(true);
        mDialog.show();

        mDialog.getWindow().setDimAmount(0.4f);//设置透明度0.4
        window = mDialog.getWindow();
        window.setLayout(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        window.setContentView(mDialogLayout);//设置弹框布局
        mDialog.setCanceledOnTouchOutside(false);
        window.setWindowAnimations(R.style.dialogOpenAnimation);  //添加动画
        window.setGravity(Gravity.BOTTOM);//底部

    }

    /**
     * 得到PayPassView控件
     * @return
     */
    public SetPayPassView getPayViewPass() {
        return  mDialogLayout.findViewById(R.id.pay_View);

    }


    /**
     * 点击外部消失
     */
    public SetPasswordDialog setOutColse(boolean isOut){
        if (isOut){
            mDialog.setCanceledOnTouchOutside(true);
        }
        else {
            mDialog.setCanceledOnTouchOutside(false);
        }
        return this;
    }
    /**
     * 关闭
     */

    public void dismiss() {
        if(mDialog!=null&&mDialog.isShowing()){
            mDialog.dismiss();
            mDialog=null;//清空对象
            window=null;
        }
    }

}
