package com.xxrv.wallet.activity;

import android.content.ComponentName;
import android.content.Intent;;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.xxrv.wallet.R;
import com.xxrv.wallet.R2;
import com.xxrv.wallet.adapter.WalletCathAdapter;
import com.xxrv.wallet.bean.WalletcathListBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import butterknife.BindView;

/******
 * 提现记录
 */
public class EnchashmentRecordActivity extends BaseStatusActivity<CommonPresenter> implements BaseQuickAdapter.RequestLoadMoreListener, SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;

    @BindView(R2.id.refresh)
    SimpleRefreshLayout simpleRefreshLayout;
    private int pageNo = 1;
    private int pageSize = 10;
    private int pageTotal = 0;

    private WalletCathAdapter adapter;

    @Override
    public void onShowResult(int requestType, BaseBean result) {

        if (requestType == 0) {
            WalletcathListBean bean = (WalletcathListBean) result;
            if (bean != null && bean.isRel() && bean.getData() != null && bean.getData().getWalletCaths() != null) {
                if (pageNo == 1) {
                    pageTotal = bean.getData().getTotalPage();
                    adapter.setNewData(bean.getData().getWalletCaths());
                    simpleRefreshLayout.onRefreshComplete();
                    if (bean.getData().getWalletCaths().size() == 0) {
                        adapter.setEmptyView(getEmptyView(recyclerView, -1, getString(R.string.rv_select_not_data)));
                        adapter.notifyDataSetChanged();
                    }
                } else {
                    adapter.addData(bean.getData().getWalletCaths());
                    adapter.loadMoreComplete();
                }
            }
        }

    }

    @Override
    protected int setLayout() {
        return R.layout.activity_enchashment_record;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("提现记录");
        recyclerView.setLayoutManager(new LinearLayoutManager(this, LinearLayout.VERTICAL, false));
        adapter = new WalletCathAdapter(new ArrayList<WalletcathListBean.ItemWalletcath>());
        adapter.setOnLoadMoreListener(this, recyclerView);
        simpleRefreshLayout.setHeaderView(new SimpleRefreshView(this));
        simpleRefreshLayout.setOnSimpleRefreshListener(this);
        recyclerView.setAdapter(adapter);
        adapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                String url = RvFrameConfig.HOST + "/h5/appHtml/view/withdrawDetail.html?id=" + ((WalletcathListBean.ItemWalletcath) adapter.getItem(position)).getId();
                ComponentName componentName = new ComponentName(getApplicationContext(), "com.rv.share.WebViewActivity");
                Intent intent = new Intent();
                intent.setComponent(componentName);
                intent.putExtra("url", url);
                intent.putExtra("title", "提现详情");
                startActivity(intent);

            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        getData();
    }

    @Override
    public void onLoadMoreRequested() {
        if (pageNo >= pageTotal) {
            adapter.loadMoreEnd();
        } else {
            pageNo++;
            getData();
        }
    }

    @Override
    public void onRefresh() {
        pageNo = 1;
        getData();
    }

    public void getData() {
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            Map<String, Object> header = new HashMap<>();
            header.put("Authorization", OkGoUtil.getToken());

            Map<String, Object> map = new HashMap<>();
            map.put("pageNo", pageNo);
            map.put("pageSize", pageSize);
            mPresenter.getData(RvFrameConfig.HOST, 0, ApiConfig.HTTP_URL_WALLETCATH_LIST, WalletcathListBean.class, map, header, true);
        }

    }

}
