package com.rv.share;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.base.utils.tools.android.NetworkUtil;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.share.presenter.WebViewPresenter;
import com.rv.share.view.RvWebView;

import butterknife.BindView;

public class WebViewActivity extends BaseStatusActivity<WebViewPresenter> {
    @BindView(R2.id.ll_content)
    LinearLayout llContent;
    private String url;
    private String title;
    private RvWebView rvWebView;

    public static Intent getIntent(Context context, String url, String name) {
        Intent intent = new Intent(context, WebViewActivity.class);
        intent.putExtra("url", url);
        intent.putExtra("title", name);
        return intent;
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_web_view;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        // 获取唤醒参数
        url = intent.getStringExtra("url");
        title = intent.getStringExtra("title");
        if (!TextUtils.isEmpty(title)) {
            titleView.setTitle(title);
        } else {
            titleView.setVisibility(View.GONE);
        }
        rvWebView = new RvWebView(getApplicationContext(), listener);
        if (NetworkUtil.isNetworkAvailable(this)) {
            llContent.addView(rvWebView);
            if (!TextUtils.isEmpty(url)) {
//            url = "https://xxtest.upyuns.com/h5/appHtml/view/invitationCourtesy.html" ;
                rvWebView.loadUrl(url);
            }
        } else {
            Toast.makeText(this, "网络异常", Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        if (rvWebView != null)
            mPresenter.setWebView(rvWebView);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    public void onDestroy() {
        if (rvWebView != null) {
            llContent.removeAllViews();
            rvWebView.stopLoading();// 停止当前加载
            rvWebView.clearMatches();// 清除网页查找的高亮匹配字符。
            rvWebView.clearHistory();// 清除当前 WebView 访问的历史记录
            rvWebView.clearSslPreferences();//清除ssl信息
            rvWebView.clearCache(true);//清空网页访问留下的缓存数据。需要注意的时，由于缓存是全局的，所以只要是WebView用到的缓存都会被清空，即便其他地方也会使用到。该方法接受一个参数，从命名即可看出作用。若设为false，则只清空内存里的资源缓存，而不清空磁盘里的。
            rvWebView.loadUrl("about:blank");// 清空当前加载
            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR2) {
                rvWebView.removeJavascriptInterface("AndroidNative");// 向 Web端注入 java 对象
            }
            rvWebView.destroy();// 生命周期销毁
        }

        super.onDestroy();
    }

    private RvWebView.WebViewListener listener = new RvWebView.WebViewListener() {
        @Override
        public void share(String url, String imgUrl, String title, String circleTitle, String desc) {
            mPresenter.showShareDialog(url, imgUrl, title, circleTitle, desc);
        }

        @Override
        public void share(String url, String title, String desc) {
            mPresenter.showShareDialog(url, null, title, null, desc);
        }

        @Override
        public void finish() {

        }
    };
}
