package com.rv.share;

import android.Manifest;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.CardView;
import android.view.View;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.share.presenter.BillPresenter;
import com.rv.share.view.RvWebView;

import butterknife.BindView;
import butterknife.OnClick;

/********
 *
 * 海报界面
 * created by john
 */
public class BillActivity extends BaseStatusActivity<BillPresenter> {

    @BindView(R2.id.tv_back_title)
    TextView tvBackTitle;
    @BindView(R2.id.btn_share)
    Button btnShare;
    @BindView(R2.id.ll_webview)
    CardView llContent;

    private String url;
    private RvWebView rvWebView;

    public static Intent getIntent(Context var1, String var2) {
        Intent intent = new Intent(var1, BillActivity.class);
        intent.putExtra("billUrl", var2);
        return intent;
    }


    @Override
    protected int setLayout() {
        return R.layout.activity_bill;
    }


    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {

        url = intent.getStringExtra("billUrl");
        titleView.setVisibility(View.GONE);

        rvWebView = new RvWebView(getApplicationContext(), listener);
        llContent.addView(rvWebView);
        rvWebView.loadUrl(url);

//        llLongClick.setOnLongClickListener(new View.OnLongClickListener() {
//            @Override
//            public boolean onLongClick(View view) {
//                mPresenter.showShareDialog(llBillContent);
//                return false;
//            }
//        });

//        Bitmap success = ZxingUtils.createQRImage(testUrl, DisplayUtil.dip2px(this, 80f), DisplayUtil.dip2px(this, 80f),
//                BitmapFactory.decodeResource(getResources(), com.rv.home.R.mipmap.ic_launcher));
//        imgZxing.setImageBitmap(success);
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    public void onDestroy() {
        if (rvWebView != null) {
            llContent.removeAllViews();
            rvWebView.stopLoading();// 停止当前加载
            rvWebView.clearMatches();// 清除网页查找的高亮匹配字符。
            rvWebView.clearHistory();// 清除当前 WebView 访问的历史记录
            rvWebView.clearSslPreferences();//清除ssl信息
            rvWebView.clearCache(true);//清空网页访问留下的缓存数据。需要注意的时，由于缓存是全局的，所以只要是WebView用到的缓存都会被清空，即便其他地方也会使用到。该方法接受一个参数，从命名即可看出作用。若设为false，则只清空内存里的资源缓存，而不清空磁盘里的。
            rvWebView.loadUrl("about:blank");// 清空当前加载
            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR2) {
                rvWebView.removeJavascriptInterface("AndroidNative");// 向 Web端注入 java 对象
            }
            rvWebView.destroy();// 生命周期销毁
        }
        super.onDestroy();
    }

    @OnClick({R2.id.tv_back_title, R2.id.btn_share})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.tv_back_title) {
            finish();
        } else if (id == R.id.btn_share) {
            preShare();
        }
    }

    private RvWebView.WebViewListener listener = new RvWebView.WebViewListener() {
        @Override
        public void share(String url, String imgUrl, String title, String circleTitle, String desc) {

        }

        @Override
        public void share(String url, String title, String desc) {
        }

        @Override
        public void finish() {

        }
    };


    /**
     * 预备下载 进行 6.0权限检查
     */
    private void preShare() {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            mPresenter.showShareDialog(llContent, rvWebView);
        } else {
            if (ContextCompat.checkSelfPermission(this,
                    Manifest.permission.WRITE_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED) {
                mPresenter.showShareDialog(llContent, rvWebView);
            } else {//申请权限
                ActivityCompat.requestPermissions(this,
                        new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE}, 1001);
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1001:
                if (grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    mPresenter.showShareDialog(llContent, rvWebView);
                    ;
                } else {
                    Toast.makeText(getApplicationContext(), "授权失败,无法分享海报", Toast.LENGTH_SHORT).show();
                }
                break;
        }
    }
}
