package com.rv.search;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;

import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.KeyboardUtil;
import com.rv.plugin.search.R;
import com.rv.plugin.search.R2;
import com.rv.search.adapter.TravelSearchAdapter;
import com.rv.search.api.SearchApi;
import com.rv.search.bean.BeanTravelSearch;
import com.rv.search.presenter.SearchPresenter;

import java.util.HashMap;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * 旅游搜索
 */
@Route(path = Constance.ACTIVITY_URL_TRAVELSEARCH)
public class TravelSearchActivity extends BaseStatusActivity<SearchPresenter> {

    @BindView(R2.id.et_search)
    EditText etSearch;
    @BindView(R2.id.rv_content)
    RecyclerView rvContent;

    private int mPage;
    private int countPage;

    @Autowired()
    double latLatitude = 0;
    @Autowired()
    double lonLongitude;
    @Autowired()
    String city;

    private TravelSearchAdapter mTravelSearchAdapter;

    @Override
    protected int setLayout() {
        return R.layout.activity_travel_search;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);

        mTravelSearchAdapter = new TravelSearchAdapter();
        rvContent.setLayoutManager(new LinearLayoutManager(mActivity, LinearLayoutManager.VERTICAL, false));
        rvContent.setAdapter(mTravelSearchAdapter);

        mTravelSearchAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                BeanTravelSearch.DataBeanX.DataBean dataBean = (BeanTravelSearch.DataBeanX.DataBean) adapter.getItem(position);
                if (dataBean !=null){
                    ARouter.getInstance()
                            .build(Constance.ACTIVITY_URL_TRAVELDETAILS)
                            .withString("id", dataBean.getId())
                            .withString("name", dataBean.getName())
                            .withString("content", dataBean.getContent())
                            .withString("url", dataBean.getCover())
                            .withDouble("price",Double.valueOf(dataBean.getPrice()))
                            .navigation();
                    finish();
                }
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        if (!TextUtil.isEmpty(city)){
            etSearch.setText(city);
            etSearch.setSelection(city.length());
            loadTourAroundData("");
        }
    }

    @OnClick({R2.id.iv_back, R2.id.tv_search})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.iv_back){
            finish();
        }else if (id == R.id.tv_search){
            String content = etSearch.getText().toString().trim();
            if (TextUtils.isEmpty(content)){
                showToast("请输入搜索内容！");
                return;
            }
            loadTourAroundData(content);
        }
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
         switch (requestType){
             case 0:
                 setData((BeanTravelSearch) result);
                 break;
         }
    }

    private void setData(BeanTravelSearch data) {
        KeyboardUtil.hideKeyboard(mActivity);
        if (mPage == 1) {
             mTravelSearchAdapter.getData().clear();
             mTravelSearchAdapter.notifyDataSetChanged();
            if (data.getData().getTotalCount() == 0) {
                mTravelSearchAdapter.setEmptyView(getEmptyView(rvContent, -1, "暂无数据！"));
                return;
            }

            countPage = data.getData().getTotalPage();
            mTravelSearchAdapter.addNewData(data);
            mTravelSearchAdapter.loadMoreComplete();
        } else {
            mTravelSearchAdapter.addData(data.getData().getData());
            mTravelSearchAdapter.loadMoreComplete();
        }
    }


    /**
     * 获取周边游
     */
    private void loadTourAroundData(String search) {
        mPage = 1;
        getLoadTourAroundData(mPage,search);
    }

    private void getLoadTourAroundData(int page,String search) {
        HashMap<String, Object> map = new HashMap<>();
        map.put("query", search);
        map.put("page", page);
        map.put("limit", "10");
        map.put("distance", 10.0);
        map.put("latitude", latLatitude);
        map.put("longitude", lonLongitude);
        mPresenter.getData(0, SearchApi.QUERY_RIM_LIST, BeanTravelSearch.class, map, true);
    }
}
