package com.rv.points;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;

import com.alibaba.android.arouter.launcher.ARouter;
import com.frame.base.url.Constance;

import java.math.BigDecimal;

public class Actions {

    public Actions() {
    }

    /*******
     * 分享
     */
    public void share(Context context) {
        ComponentName name = new ComponentName(context, "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        intent.putExtra("to", "home");
        context.startActivity(intent);
    }

    /******
     * 实名认证
     * @param context
     */
    public void cretification(Context context) {
        ARouter.getInstance().build(Constance.ACTIVITY_URL_IDCARDCERTIFICATION)
                .navigation((Activity) context, 1000);
    }

    /******
     * 购买会员
     * @param context
     */
    public void buymember(Context context) {
        ComponentName name = new ComponentName(context, "com.rv.member.MemberCenterActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        ((Activity) context).startActivityForResult(intent, 1001);
    }

    /*******
     * 图文评论
     * @param context
     */
    public void commentandpic(Context context) {

        ARouter.getInstance().build(Constance.ACTIVITY_URL_ORDERLIST)
                .withInt("position", 3)
                .navigation((Activity) context, 1002);
    }

    /******
     * 评论
     * @param context
     */
    public void comment(Context context) {
        ARouter.getInstance().build(Constance.ACTIVITY_URL_ORDERLIST)
                .withInt("position", 3)
                .navigation((Activity) context, 1002);
    }

    /*****
     * 签到
     * @param context
     */
    public static void sign(Context context) {
        ((Activity) context).startActivityForResult(new Intent(context, SignActivity.class), 1003);
    }

    /******
     * 绑定微信
     * @param context
     */
    public void bindwechat(Context context) {

    }

    /*****
     * 注册
     * @param context
     */
    public void register(Context context) {

    }

    /*****
     * 房车租赁
     * @param context
     */
    public void rentrv(Context context) {
        ComponentName name = new ComponentName(context, "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        intent.putExtra("to", "home");
        context.startActivity(intent);
    }

    /****
     * 房车购买
     * @param context
     */
    public void buyrout(Context context) {
        ComponentName name = new ComponentName(context, "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        intent.putExtra("to", "travel");
        context.startActivity(intent);
    }

    /*****
     * 参与官方活动
     */
    public void official(Context context) {
        ComponentName name = new ComponentName(context, "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        intent.putExtra("to", "home");
        context.startActivity(intent);
    }

    /****
     *  发表动态
     * @param context
     */
    public void publish(Context context) {
        ComponentName name = new ComponentName(context, "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        intent.putExtra("to", "discovery");
        context.startActivity(intent);
    }

    public void commentpublish(Context context) {
        ComponentName name = new ComponentName(context, "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        intent.putExtra("to", "discovery");
        context.startActivity(intent);
    }
}
