package com.rv.rvmine.adapter;

import android.widget.ImageView;

import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.rv.rvmine.R;
import com.rv.rvmine.bean.CollectionListBean;

import java.util.List;

/**
 * 收藏人列表
 */

public class CollectionAdapter extends BaseMultiItemQuickAdapter<MultiItemEntity, BaseGlideHolder> {
    public static final int TYPE_COLLECTION_CARRENTAL = 1;
    public static final int TYPE_COLLECTION_TRAVEL = 2;

    public CollectionAdapter(List<MultiItemEntity> data) {
        super(data);
        addItemType(TYPE_COLLECTION_CARRENTAL, R.layout.rv_item_mine_collection_car_rental);
        addItemType(TYPE_COLLECTION_TRAVEL, R.layout.rv_item_mine_collection_travel);
    }

    @Override
    protected void convert(BaseGlideHolder helper, MultiItemEntity item) {
        switch (helper.getItemViewType()) {
            case TYPE_COLLECTION_CARRENTAL:
                CollectionListBean.DataBeanX.DataBean dataBean = (CollectionListBean.DataBeanX.DataBean) item;
                if (dataBean == null) {
                    return;
                }
                helper.setText(R.id.tv_car_name,dataBean.getName());
                helper.setText(R.id.tv_car_price, String.format("￥%1$s", dataBean.getPrice()));
                helper.loadRoundImage(mContext, dataBean.getCover(), (ImageView) helper.getView(R.id.iv_car_icon), 10);

                break;
            case TYPE_COLLECTION_TRAVEL:
                CollectionListBean.DataBeanX.DataBean dataBean2 = (CollectionListBean.DataBeanX.DataBean) item;
                if (dataBean2 == null) {
                    return;
                }

                helper.setText(R.id.tv_tour_name,dataBean2.getName());
                helper.setText(R.id.tv_tour_price, String.format("￥%1$s", dataBean2.getPrice()));
                helper.loadRoundImage(mContext, dataBean2.getCover(), (ImageView) helper.getView(R.id.iv_tour_icon), 10);
                break;
        }
    }
    public void addNewData(CollectionListBean bean) {
        mData.clear();
        addData(bean.getData().getData());
        notifyDataSetChanged();
    }
}
