package com.rv.home.rv.module.ui.main.home.order;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.webkit.WebView;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.bus.CancelOrderEvent;
import com.frame.base.bus.RxBus;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.home.rv.module.basic.presenter.PickerPresenter;
import com.rv.home.rv.module.ui.main.home.dialog.TipsDialog;
import com.rv.home.rv.module.ui.main.home.order.adapter.CancelTheTripAdapter;
import com.rv.home.rv.module.ui.main.home.order.bean.CancelTheTripBean;
import com.rv.home.rv.module.ui.main.home.order.bean.CancelTheTripDataBean;
import com.rv.home.rv.module.ui.main.home.order.bean.CancelTheTripTextDataBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * 取消行程
 */

public class CancelTheTripActivity extends BaseStatusActivity<PickerPresenter> {

    @BindView(R2.id.recyclerView)
    RecyclerView mRecyclerView;
    @BindView(R2.id.tv_content)
    TextView tvContent;

    private CancelTheTripAdapter mAdapter;
    private String no;
    private String type;
    private TipsDialog dialog;

    private CancelTheTripDataBean.DataBean data;

    public static Intent getIntent(Context context, String no,String type) {
        return new Intent(context, CancelTheTripActivity.class)
                .putExtra("no", no)
                .putExtra("type",type);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                showToast("取消成功！");
                RxBus.post(new CancelOrderEvent());
                finish();
                break;

            case 2:
                setData((CancelTheTripDataBean) result);
                break;
            case 3:
                setTextData((CancelTheTripTextDataBean) result);
                break;
        }
    }

    private void setTextData(CancelTheTripTextDataBean bean) {
        if (bean !=null && bean.getData() !=null && bean.getData().size() >0 ){
            tvContent.setText(Html.fromHtml(bean.getData().get(0).getValue()));
        }
    }

    private void setData(CancelTheTripDataBean bean) {
        data = bean.getData();
    }


    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        getData();
        getTextData();
    }

    private void getTextData() {
        mPresenter.getData(RvFrameConfig.HOST, 3, ApiConfig.HTTP_URL_UNAUTH_TYPES + "?types=" + type, CancelTheTripTextDataBean.class, false);
    }

    private void getData() {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null) {
            headMap.put("Authorization", OkGoUtil.getToken());
            mPresenter.getDataHead(RvFrameConfig.HOST, 2, ApiConfig.HTTP_URL_PRICE_CALCULATE + no, CancelTheTripDataBean.class, headMap, false);
        }
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_cancel_the_trip;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle(mActivity.getString(R.string.cancel_the_trip));

        no = intent.getStringExtra("no");
        type = intent.getStringExtra("type");

        mAdapter = new CancelTheTripAdapter();
        mRecyclerView.setLayoutManager(new LinearLayoutManager(mActivity));
        mRecyclerView.setAdapter(mAdapter);
        data();

        mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                mAdapter.setSelectPosition(position);
            }
        });
    }

    @OnClick(R2.id.tv_ok)
    public void onViewClicked() {
        new TipsDialog(mActivity) {
            @Override
            public void helper(ViewHolder helper) {
                super.helper(helper);
                if (data != null) {
                    helper.setText(R.id.tv_content, data.getRefundDesc());
                }

                helper.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        int id = v.getId();
                        if (id == R.id.tv_ok) {
                            if (TextUtils.isEmpty(mAdapter.getSelectName())) {
                                showToast("请选择取消原因！");
                                return;
                            }
                            Map<String, Object> mapHead = new LinkedHashMap<>();
                            mapHead.put("Authorization", OkGoUtil.getToken());

                            mPresenter.postBodyData(RvFrameConfig.VEHICLE_ORDER, 0, ApiConfig.HTTP_URL_BASEORDER_CANCEL + no, CancelTheTripBean.class, new cancelReasonBean(mAdapter.getSelectName()), mapHead, true);
                            dismiss();
                        } else if (id == R.id.tv_cancel) {
                            dismiss();
                        }
                    }
                }, R.id.tv_ok, R.id.tv_cancel);
            }
        }.show();

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // TODO: add setContentView(...) invocation
        ButterKnife.bind(this);
    }


    private class cancelReasonBean {
        private String cancelReason;

        public cancelReasonBean(String cancelReason) {
            this.cancelReason = cancelReason;
        }

        public String getCancelReason() {
            return cancelReason;
        }

        public void setCancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
        }
    }

    private void data() {
        ArrayList<CancelTheTripBean> list = new ArrayList<>();
        CancelTheTripBean bean = new CancelTheTripBean();
        bean.setName("行程有变，换其他出行方式");
        list.add(bean);
        CancelTheTripBean bean2 = new CancelTheTripBean();
        bean2.setName("租车费用太贵");
        list.add(bean2);
        CancelTheTripBean bean3 = new CancelTheTripBean();
        bean3.setName("驾照丢失");
        list.add(bean3);
        CancelTheTripBean bean4 = new CancelTheTripBean();
        bean4.setName("身体不适");
        list.add(bean4);
        CancelTheTripBean bean5 = new CancelTheTripBean();
        bean5.setName("其他原因");
        list.add(bean5);
        mAdapter.addData(list);
    }
}
