package com.xxrv.video.adapter;

import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.xxrv.video.R;
import com.xxrv.video.bean.circle.MusicInfo;

/**
 * 音乐选择
 */

public class SelectMusicAdapter extends BaseQuickAdapter<MusicInfo, BaseViewHolder> {

    public SelectMusicAdapter() {
        super(R.layout.item_trill_music);
    }

    @Override
    protected void convert(BaseViewHolder helper, MusicInfo item) {
        helper.setText(R.id.tv_name, item.getName());
        helper.setText(R.id.tv_nike_name, item.getNikeName());
        GlideManager.getInstance(mContext).loadImage(item.getCover(), (ImageView) helper.getView(R.id.iv_cover));

        if (item.state == 0) {
            helper.setGone(R.id.ll_next, false);
            helper.setImageResource(R.id.iv_play_state, R.drawable.ic_music_state0);
        } else if (item.state == 1) {
            helper.setGone(R.id.ll_next, true);
            helper.setImageResource(R.id.iv_play_state, R.drawable.ic_music_state2);
        } else if (item.state == 2) {
            helper.setGone(R.id.ll_next, false);
            helper.setImageResource(R.id.iv_play_state, R.drawable.ic_music_state1);
        } else if (item.state == 3) {
            helper.setGone(R.id.ll_next, true);
            helper.setImageResource(R.id.iv_play_state, R.drawable.ic_music_state0);
        }

        helper.addOnClickListener(R.id.rl_content);
        helper.addOnClickListener(R.id.ll_next);
    }
}
