package com.rv.share.adapter;

import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.base.utils.ui.image.round.RoundImageView;
import com.bumptech.glide.Glide;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.component.utils.DateUtils;
import com.rv.share.R;
import com.rv.share.bean.IncomeRecordsBean;
import com.rv.share.bean.PopularizeBean;

import java.util.List;

public class PopularizeListAdapter extends BaseQuickAdapter<PopularizeBean.PopularizeItem, BaseViewHolder> {

    public PopularizeListAdapter(@Nullable List<PopularizeBean.PopularizeItem> data) {
        super(R.layout.item_popularize_view, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, PopularizeBean.PopularizeItem item) {

        helper.setText(R.id.tv_number, "" + (getData().indexOf(item) + 1));
        if (!TextUtils.isEmpty(item.getHeadUrl())) {
            GlideManager.getInstance(mContext).loadImage(item.getHeadUrl(), (RoundImageView) helper.itemView.findViewById(R.id.iv_header));
        }
        helper.setText(R.id.tv_name, !TextUtils.isEmpty(item.getRealName()) ? item.getRealName() : dealPhone(item.getUserName()));
        helper.setText(R.id.tv_value, "共" + item.getIncome() + "元");
    }

    private String dealPhone(String name) {
        if (!TextUtils.isEmpty(name)) {
            if (name.length() == 11) {
                return name.substring(0, 3) + "****" + name.substring(7, name.length());
            }
        }
        return name;
    }
}
