package com.rv.member.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.rv.member.R;

public class UnLoginView extends RelativeLayout {
    private TextView tvLogin;
    private OnClickListener onClickListener;

    public UnLoginView(Context context) {
        super(context);
        initView();
    }

    public UnLoginView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView();
    }

    public void setLoginListener(OnClickListener listener) {
        this.onClickListener = listener;
    }

    @SuppressLint("ResourceAsColor")
    private void initView() {
        View view = LayoutInflater.from(getContext()).inflate(R.layout.item_unlogin_view, null);
        tvLogin = view.findViewById(R.id.tv_login);
        tvLogin.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (onClickListener != null) onClickListener.onClick(v);
            }
        });
        setBackgroundColor(Color.parseColor("#ffffff"));
        addView(view);
    }

}
