package com.rv.member.view;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.alibaba.android.arouter.launcher.ARouter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.bean.UserInfoBean;
import com.rv.component.utils.CacheEnum;
import com.rv.component.utils.RvCache;
import com.rv.member.MemberCenterActivity;
import com.rv.member.R;
import com.rv.member.adapter.GridMemerAdapter;
import com.rv.member.bean.MemberListBean;
import com.rv.tourism.api.TourismApi;
import com.yuyife.okgo.OkGoUtil;

public class MemberTopView extends LinearLayout {

    private UnLoginView unlogin_view;
    private LoginView logined_view;
    private TextView tv_agreement;
    private ImageView img_agree;
    private Button btn_buy;
    private LinearLayout llTop;
    private ImageView imgDiscountTop;
    private TextView tvDiscountTop;
    private Button btnDisountUse;
    private ImageView imgFreedayTop;
    private TextView tvFreedayTop;
    private Button btnFreedayUse;
    private ImageView imgFreeTop;
    private TextView tvFreeTop;
    private GridView gridview;
    private MemberListBean bean;
    private View viewLine;
    private TextView tvInviterPhone;

    private String inviterPhone;


    private MemberListBean.MemberCard selectCard;
    private int selectPostion;
    private MemberCenterActivity.PayListener listener;
    private int memberLevel;
    private int freeUseDay;

    private GridMemerAdapter adapter;

    private UserInfoBean.UserInfo info;

    private boolean hasAgree = false;

    private OnClickListener clickListener;

    private InviterPhoneDialog dialog;

    public MemberTopView(Context context) {
        super(context);
    }

    public MemberTopView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView();
    }

    public void setData(MemberListBean bean, int memberLevel, int freeUseDay, MemberCenterActivity.PayListener listener) {
        this.bean = bean;
        this.listener = listener;
        this.memberLevel = memberLevel;
        this.freeUseDay = freeUseDay;
        selectPostion = 0;
        selectCard = bean.getData().get(selectPostion);
        setHeadViewData();
    }

    public void setLoginListener(OnClickListener clickListener) {
        this.clickListener = clickListener;
        unlogin_view.setLoginListener(clickListener);
    }

    private void initView() {

        View view = LayoutInflater.from(getContext()).inflate(R.layout.view_member_top, null);
        unlogin_view = view.findViewById(R.id.unlogin_view);
        logined_view = view.findViewById(R.id.logined_view);
        gridview = view.findViewById(R.id.gridview);
        tv_agreement = view.findViewById(R.id.tv_agreement);
        img_agree = view.findViewById(R.id.img_agree);
        btn_buy = view.findViewById(R.id.btn_buy);
        llTop = view.findViewById(R.id.ll_member_top);
        imgDiscountTop = view.findViewById(R.id.img_discount_top);
        tvDiscountTop = view.findViewById(R.id.tv_discount_top);
        btnDisountUse = view.findViewById(R.id.btn_disount_use);
        imgFreedayTop = view.findViewById(R.id.img_freeday_top);
        tvFreedayTop = view.findViewById(R.id.tv_freeday_top);
        btnFreedayUse = view.findViewById(R.id.btn_freeday_use);
        imgFreeTop = view.findViewById(R.id.img_free_top);
        tvFreeTop = view.findViewById(R.id.tv_free_top);
        viewLine = view.findViewById(R.id.view_line);
        tvInviterPhone = view.findViewById(R.id.tv_inviter_phone);
        if (TextUtils.isEmpty(OkGoUtil.getToken())) {
            unlogin_view.setVisibility(View.VISIBLE);
            logined_view.setVisibility(View.GONE);
        } else {
            UserInfoBean userInfoBean = (UserInfoBean) RvCache.getInstance().get(CacheEnum.USER);
            if (userInfoBean != null) {
                setUserInfoData(userInfoBean);
            }
        }

        tvInviterPhone.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (dialog == null) {
                    dialog = new InviterPhoneDialog(getContext(), inviterPhone, new InviterPhoneDialog.InputListener() {
                        @Override
                        public void input(String phone) {
                            inviterPhone = phone;
                        }
                    });
                }
                dialog.show();
            }
        });

        addView(view);
    }


    private void setHeadViewData() {
        setMemeberTop();
        SpannableString spannableString = new SpannableString(tv_agreement.getText());
        spannableString.setSpan(new ForegroundColorSpan(Color.parseColor("#309EFF")), 3, spannableString.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        tv_agreement.setText(spannableString);
        tv_agreement.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                        .withString("title", "合同协议")
                        .withString("url", TourismApi.HTTP_URL_CAR_TYPE_NOTICE)
                        .withInt("type", 18)
                        .navigation();
            }
        });

        img_agree.setImageResource(hasAgree ? R.drawable.common_icon_selected : R.drawable.common_icon_radio_unche);
//        if (selectCard.getLevel() == 1) {
//            btn_buy.setBackgroundResource(R.drawable.shape_rv_bg_open_normal_member);
//        } else if (selectCard.getLevel() == 2) {
//            btn_buy.setBackgroundResource(R.drawable.shape_rv_bg_open_gold_member);
//        } else {
//            btn_buy.setBackgroundResource(R.drawable.shape_rv_bg_open_diamond_member);
//        }
        btn_buy.setBackgroundResource(R.drawable.shape_rv_bg_open_member);
        img_agree.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (hasAgree) {
                    hasAgree = false;
                    img_agree.setImageResource(R.drawable.common_icon_radio_unche);
                } else {
                    hasAgree = true;
                    img_agree.setImageResource(R.drawable.common_icon_selected);
                }
                if (listener != null) {
                    listener.checkAgreement(hasAgree);
                }

            }
        });

        btn_buy.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (!hasAgree) {
                    Toast.makeText(getContext(), "需同意服务协议", Toast.LENGTH_SHORT).show();
                    return;
                }
                if (listener != null) {
                    listener.pay(selectCard, inviterPhone);
                }
            }
        });
        initGridView();
        btn_buy.setText("立即开通" + selectCard.getName());
        btnDisountUse.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                toMainActivity();
            }
        });

        btnFreedayUse.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                toMainActivity();
            }
        });
    }

    private void setMemeberTop() {
        if (memberLevel > 0) {
            llTop.setVisibility(VISIBLE);
            viewLine.setVisibility(VISIBLE);
            tvFreedayTop.setText("免费用车" + freeUseDay + "天");

            switch (memberLevel) {
                case 1:
                    imgDiscountTop.setImageResource(R.drawable.member_common_icon_discount);
                    imgFreedayTop.setImageResource(R.drawable.member_common_icon_rent);
                    imgFreeTop.setImageResource(R.drawable.member_common_icon_salon);
                    tvDiscountTop.setText("租车8折");
                    btnFreedayUse.setBackgroundResource(R.drawable.shape_member_common_bg_btn);
                    btnDisountUse.setBackgroundResource(R.drawable.shape_member_common_bg_btn);
                    break;
                case 2:
                    imgDiscountTop.setImageResource(R.drawable.member_gold_icon_discount);
                    imgFreedayTop.setImageResource(R.drawable.member_gold_icon_rent);
                    imgFreeTop.setImageResource(R.drawable.member_gold_icon_salon);
                    tvDiscountTop.setText("租车7折");
                    btnFreedayUse.setBackgroundResource(R.drawable.shape_member_gold_bg_btn);
                    btnDisountUse.setBackgroundResource(R.drawable.shape_member_gold_bg_btn);
                    break;
                case 3:
                    imgDiscountTop.setImageResource(R.drawable.member_diamond_icon_discount);
                    imgFreedayTop.setImageResource(R.drawable.member_diamond_icon_rent);
                    imgFreeTop.setImageResource(R.drawable.member_diamond_icon_salon);
                    tvDiscountTop.setText("租车6折");
                    btnFreedayUse.setBackgroundResource(R.drawable.shape_member_diamond_bg_btn);
                    btnDisountUse.setBackgroundResource(R.drawable.shape_member_diamond_bg_btn);
                    break;
            }
        } else {
            viewLine.setVisibility(GONE);
            llTop.setVisibility(GONE);
        }
    }

    public void setUserInfoData(UserInfoBean infoBean) {
        if (infoBean != null) {
            info = infoBean.getData();
            if (info != null) {
                unlogin_view.setVisibility(View.GONE);
                logined_view.setData(infoBean);
                logined_view.setVisibility(View.VISIBLE);
                freeUseDay = infoBean.getData().getRentFreeDays();
                tvFreedayTop.setText("免费用车" + freeUseDay + "天");
                if (info.getIsMember() == 0) {
                    memberLevel = 0;
                    setMemeberTop();
                } else {
                    memberLevel = info.getMemberLevel();
                    setMemeberTop();
                }
            }
        }
    }

    private void initGridView() {
        gridview.setNumColumns(bean.getData().size());
        if (adapter == null) {
            adapter = new GridMemerAdapter(getContext(), bean.getData(), new GridMemerAdapter.SelectListener() {
                @Override
                public void select(MemberListBean.MemberCard memberCard) {
                    selectCard = memberCard;
                    selectPostion = bean.getData().indexOf(memberCard);
                    btn_buy.setText("立即开通" + memberCard.getName());
                    btn_buy.setBackgroundResource(R.drawable.shape_rv_bg_open_member);
//                    if (selectCard.getLevel() == 1) {
//                        btn_buy.setBackgroundResource(R.drawable.shape_rv_bg_open_normal_member);
//                    } else if (selectCard.getLevel() == 2) {
//                        btn_buy.setBackgroundResource(R.drawable.shape_rv_bg_open_gold_member);
//                    } else {
//                        btn_buy.setBackgroundResource(R.drawable.shape_rv_bg_open_diamond_member);
//                    }
                }
            });
        }
        gridview.setAdapter(adapter);
    }

    private void toMainActivity() {
        ComponentName componentName = new ComponentName(getContext(), "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.putExtra("to", "home");
        intent.setComponent(componentName);
        getContext().startActivity(intent);
    }
}
