package com.rv.member.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Toast;

import com.ruiwenliu.wrapper.dialog.BaseDialog;
import com.ruiwenliu.wrapper.weight.ToastView;
import com.rv.member.R;

public class InviterPhoneDialog extends BaseDialog {

    private EditText edtInviterPhone;
    private Button btnConfirm;
    private ImageView ivClose;

    public InviterPhoneDialog(@NonNull final Context context, String phone, final InputListener listener) {
        super(context);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
        edtInviterPhone = findViewById(R.id.edt_inviter_phone);
        ivClose = findViewById(R.id.iv_close);
        if (!TextUtils.isEmpty(phone)) {
            edtInviterPhone.setText(phone);
            edtInviterPhone.setSelection(phone.length());
        }
        btnConfirm = findViewById(R.id.btn_confirm);
        ivClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });

        btnConfirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String phone = edtInviterPhone.getText().toString().trim();
                if (!TextUtils.isEmpty(phone) && phone.length() != 11) {
                    ToastView.getInstance(context).showToastContent("请输入正确的手机号", Toast.LENGTH_SHORT);
                    return;
                }
                if (listener != null) {
                    listener.input(phone);
                }
                dismiss();
            }
        });
    }

    @Override
    public int getViewLayout() {
        return R.layout.dialog_inviter_phone;
    }

    public interface InputListener {
        void input(String phone);
    }
}
