package com.rv.member.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

import com.ruiwenliu.wrapper.util.ScaleUtils;


/***********
 * 大概逻辑
 * 1 计算出view的宽度
 * 2 画圆（左圆和右圆）
 * 3 根据进度（progress）计算出黄线起始坐标和结束左边，画黄色
 * 4 画灰线
 * 5 在左边和右边绘制文字
 * 6 提供进度的水平位置
 */

public class FreeDayProgressView extends View {

    private int total = 0;
    private int progress = 0;

    private int width;
    private int height;
    private Paint cirPaint; // 圆的画笔

    private Paint remPaint; // 剩余天数画笔
    private float progressWidth = 0;
    private int cicleRidius; // 圆半径
    private int lineWidth;
    private float drawLength;
    private DrawListener mDrawListener;

    public FreeDayProgressView(Context context) {
        super(context);
    }

    public FreeDayProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initParameter();
        initPaint();
    }

    /******
     *
     */
    private void initParameter() {
        cicleRidius = ScaleUtils.dip2px(getContext(), 5);
        lineWidth = ScaleUtils.dip2px(getContext(), 2);
    }

    /********
     * 初始化画笔
     */
    private void initPaint() {
        cirPaint = new Paint();
        cirPaint.setColor(Color.parseColor("#FFB74B"));
        cirPaint.setStrokeWidth(lineWidth);
        cirPaint.setAntiAlias(true);
        remPaint = new Paint();
        remPaint.setColor(Color.parseColor("#cccccc"));
        remPaint.setStrokeWidth(lineWidth);
        remPaint.setTextSize(ScaleUtils.sp2px(getContext(), 12));
        remPaint.setAntiAlias(true);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        width = MeasureSpec.getSize(widthMeasureSpec);
        height = MeasureSpec.getSize(heightMeasureSpec);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawCircle(cicleRidius, cicleRidius, cicleRidius, cirPaint); // 画起始圆
        canvas.drawCircle(width - cicleRidius, cicleRidius, cicleRidius, cirPaint); // 画结束的圆
        canvas.drawLine(cicleRidius * 2, cicleRidius, drawLength + cicleRidius * 2, cicleRidius, cirPaint);
        canvas.drawLine(drawLength + cicleRidius * 2, cicleRidius, width - cicleRidius * 2, cicleRidius, remPaint);
        canvas.drawText("0", 0, cicleRidius * 2 + ScaleUtils.dip2px(getContext(), 12), remPaint);
        canvas.drawText(total + "", width - remPaint.measureText(total + ""), cicleRidius * 2 + ScaleUtils.dip2px(getContext(), 12), remPaint);
        observeDraw();
    }

    /**********
     * 观察绘制流程
     */
    private void observeDraw() {
        if (drawLength < progressWidth) {
            drawLength = drawLength + 5;
            drawLength = drawLength > progressWidth ? progressWidth : drawLength;
            invalidate();
            return;
        }
        if (mDrawListener != null) {
            mDrawListener.drawFinish((int) progressWidth);
        }
    }

    /******
     * 设置进度
     * @param progress
     */
    public void setData(int total, int progress) {
        this.total = total > 0 ? total : 0;
        this.progress = progress > total ? total : (progress < 0 ? 0 : progress);
        if (total != 0) {
            progressWidth = progress / (total * 1.0f) * width;
        }
        invalidate();
    }

    /******
     * 设置进度
     * @param progress
     */
    public void setData(int total, int progress, DrawListener listener) {
        this.mDrawListener = listener;
        setData(total, progress);
    }

    public interface DrawListener {
        void drawFinish(int progressWidth);
    }
}
