package com.xxrv.invoice.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.component.utils.DateUtils;
import com.xxrv.invoice.R;
import com.xxrv.invoice.bean.OrderInvoicingCarBean;

import java.util.ArrayList;
import java.util.List;

/**
 * 按订单开票 租车 item
 */

public class OrderInvoicingCarAdapter extends BaseQuickAdapter<OrderInvoicingCarBean.DataBeanX.DataBean, BaseViewHolder> {

    public OrderInvoicingCarAdapter() {
        super(R.layout.rv_item_order_invoicing_car);
    }

    @Override
    protected void convert(BaseViewHolder helper, final OrderInvoicingCarBean.DataBeanX.DataBean item) {
        if (item.getSelectType() == 1) {
            helper.setChecked(R.id.cb_select, true);
        } else {
            helper.setChecked(R.id.cb_select, false);
        }

        helper.setText(R.id.tv_name, item.getName());

        OrderInvoicingCarBean.DataBeanX.DataBean.OrderRentVehicleDetail orderRentVehicleDetail = item.getOrderRentVehicleDetail();
        OrderInvoicingCarBean.DataBeanX.DataBean.OrderTourDetail orderTourDetail = item.getOrderTourDetail();
        OrderInvoicingCarBean.DataBeanX.DataBean.OrderMemberDetail orderMemberDetail = item.getOrderMemberDetail();
        if (orderRentVehicleDetail != null) {
            helper.setText(R.id.tv_type, "租房车");
            helper.setText(R.id.tv_get_date, "取：" + DateUtils.timestampToString1(orderRentVehicleDetail.getStart_time()) + orderRentVehicleDetail.getStart_addr());
            helper.setText(R.id.tv_out_date, "还：" + DateUtils.timestampToString1(orderRentVehicleDetail.getEnd_time()) + orderRentVehicleDetail.getEnd_addr());
            helper.setText(R.id.tv_price, String.format("¥%1$s", item.getRealAmount()));
        } else if (orderTourDetail != null) {
            helper.setText(R.id.tv_type, "房车游");
            helper.setText(R.id.tv_get_date, "出发时间：" + DateUtils.timestampToString1(orderTourDetail.getStartTime()));
            helper.setText(R.id.tv_out_date, "人数：" + orderTourDetail.getTotalNumber() + "人");
            helper.setText(R.id.tv_price, String.format("¥%1$s", item.getRealAmount()));
        } else if (orderMemberDetail != null) {
            helper.setText(R.id.tv_type, "会员");
            helper.setText(R.id.tv_get_date, orderMemberDetail.getContent());
            helper.setText(R.id.tv_out_date, item.getCrtTime());
            helper.setText(R.id.tv_price, String.format("¥%1$s", item.getRealAmount()));
        }

        helper.addOnClickListener(R.id.ll_item_bg);
        helper.addOnClickListener(R.id.cb_select);
    }


    public int getPosition(OrderInvoicingCarBean.DataBeanX.DataBean item) {
        return mData.indexOf(item);
    }


    public void setItemState(int position) {
        mData.get(position).setSelectType(mData.get(position).getSelectType() == 0 ? 1 : 0);
        notifyItemChanged(position);
    }


    public List<OrderInvoicingCarBean.DataBeanX.DataBean> getSelectItem() {
        List<OrderInvoicingCarBean.DataBeanX.DataBean> list = new ArrayList<>();
        for (OrderInvoicingCarBean.DataBeanX.DataBean dataBean : mData) {
            if (dataBean.getSelectType() == 1) {
                list.add(dataBean);
            }
        }
        return list;
    }
}
