package com.xxrv.invoice.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.component.utils.DateUtils;
import com.xxrv.invoice.R;
import com.xxrv.invoice.bean.BillingHistoryBean;

/**
 * 开票历史 item
 */

public class InvoiceBillingHistoryAdapter extends BaseQuickAdapter<BillingHistoryBean.DataBeanX.DataBean, BaseViewHolder> {

    public InvoiceBillingHistoryAdapter() {
        super(R.layout.rv_item_invoice_billing_history);
    }

    @Override
    protected void convert(BaseViewHolder helper, BillingHistoryBean.DataBeanX.DataBean item) {
        helper.setText(R.id.tv_date, DateUtils.timestampToString1(item.getCrtTime()));

        helper.setText(R.id.tv_type, item.getTitleName());
        helper.setText(R.id.tv_price, String.valueOf(item.getAmount()));

        if ("1".equals(item.getType())) {   //"订单类型 1--租车；2--旅游; 3--会员订单")
            helper.setText(R.id.tv_title, "租房车");
        } else if ("2".equals(item.getType())) {
            helper.setText(R.id.tv_title, "房车游");
        } else if ("3".equals(item.getType())) {
            helper.setText(R.id.tv_title, "会员");
        }
    }
}
