package com.xxrv.invoice.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.xxrv.invoice.R;
import com.xxrv.invoice.R2;
import com.xxrv.invoice.adapter.InvoiceBillingHistoryAdapter;
import com.xxrv.invoice.api.InvoiceApi;
import com.xxrv.invoice.bean.BillingHistoryBean;
import com.xxrv.invoice.presenter.InvoicePresenter;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * 开票历史
 */
public class BillingHistoryActivity extends BaseStatusActivity<InvoicePresenter> implements BaseQuickAdapter.RequestLoadMoreListener, SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.iv_noorder_hint)
    ImageView ivNoorderHint;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout mSimpleRefreshLayout;

    private InvoiceBillingHistoryAdapter adapter;

    private int mPage;
    private int countPage;

    public static Intent getIntent(Context context) {
        return new Intent(context, BillingHistoryActivity.class);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_billing_history;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("开票历史");

        adapter = new InvoiceBillingHistoryAdapter();
        rvContent.setLayoutManager(new LinearLayoutManager(mActivity, LinearLayoutManager.VERTICAL, false));
        adapter.setOnLoadMoreListener(this, rvContent);
        mSimpleRefreshLayout.setHeaderView(new SimpleRefreshView(this));
        mSimpleRefreshLayout.setOnSimpleRefreshListener(this);
        rvContent.setAdapter(adapter);
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        onRefresh();
    }

    private void getloadData(int page) {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        mPresenter.getData(RvFrameConfig.VEHICLE_ORDER, 0, InvoiceApi.HTTP_URL_INVOICE_SELECTBYTYPE, BillingHistoryBean.class, headMap, true);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                setData((BillingHistoryBean) result);
                break;
        }
    }

    @Override
    public void onShowError(String errorMsg, int errorType) {
        super.onShowError(errorMsg, errorType);
        mSimpleRefreshLayout.onRefreshComplete();
    }

    private void setData(BillingHistoryBean bean) {
        if (mPage == 1) {
            countPage = bean.getData().getTotalPage();
            adapter.setNewData(bean.getData().getData());
            mSimpleRefreshLayout.onRefreshComplete();
            if (bean.getData().getTotalCount() == 0) {
                ivNoorderHint.setVisibility(View.VISIBLE);
                adapter.notifyDataSetChanged();
            } else {
                ivNoorderHint.setVisibility(View.GONE);
            }
        } else {
            adapter.addData(bean.getData().getData());
            adapter.loadMoreComplete();
        }
    }

    @Override
    public void onLoadMoreRequested() {
        if (mPage >= countPage) {
            adapter.loadMoreEnd();
        } else {
            mPage++;
            getloadData(mPage);
        }
    }

    @Override
    public void onRefresh() {
        mPage = 1;
        getloadData(mPage);
    }
}
