package com.rv.im.adapter;

import android.support.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.im.R;
import com.rv.im.db.table.ChatConversation;
import com.rv.im.util.DateUtils;

import java.util.List;

public class ChatConversationAdapter extends BaseQuickAdapter<ChatConversation, BaseViewHolder> {

    public ChatConversationAdapter(@Nullable List<ChatConversation> data) {
        super(R.layout.item_conversation, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, ChatConversation conversation) {
        helper.setText(R.id.tv_name, conversation.getUserName());
        helper.setText(R.id.tv_last_msg, conversation.getLastMsg());
        helper.setText(R.id.tv_send_time, DateUtils.formatDate66(DateUtils.timestampToString1(conversation.getLastMessageTime())));
        if (conversation.getUnReadMessage() > 0) {
            helper.setVisible(R.id.tv_unread_num, true);
            helper.setText(R.id.tv_unread_num, conversation.getUnReadMessage() + "");
            helper.setVisible(R.id.img_no_unread, false);
        } else {
            helper.setVisible(R.id.tv_unread_num, false);
            helper.setVisible(R.id.img_no_unread, true);
        }

    }
}
