package com.xxrv.carpurchase.activity;

import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;

import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.util.um.CustomShareListener;
import com.ruiwenliu.wrapper.util.um.ShareManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.umeng.socialize.UMShareAPI;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.shareboard.SnsPlatform;
import com.umeng.socialize.utils.ShareBoardlistener;
import com.xxrv.carpurchase.R;
import com.xxrv.carpurchase.R2;
import com.xxrv.carpurchase.api.CarPurchaseApi;
import com.xxrv.carpurchase.presenter.CarPurchasePresenter;

import butterknife.BindView;
import butterknife.OnClick;

import static com.ruiwenliu.wrapper.weight.webview.SafeWebView.hasKitkat;

/**
 * 购车详情
 */
@Route(path = Constance.ACTIVITY_URL_DETAILCARPURCHASE)
public class DetailCarPurchaseActivity extends BaseStatusActivity<CarPurchasePresenter> {

    @BindView(R2.id.pb_progress)
    ProgressBar pbProgress;
    @BindView(R2.id.webView)
    WebView mWebView;

    private String webUrl;
    private ShareManager shareManager;

    @Autowired()
    String carId;

    @Autowired()
    String icon;

    @Autowired()
    String name;

    @Autowired()
    String keyword;

    @Autowired()
    int score;

    @Autowired()
    double buyPrice;

    @Override
    protected int setLayout() {
        return R.layout.activity_detail_car_purchase;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("购房车详情");
        webUrl = CarPurchaseApi.HTTP_URL_GOUDETAIL + "?id=" + carId;
        initWeb();
//        initShare(webUrl + "&shareType=app", mCarBean.getVehicleModel().getName(), mCarBean.getCompany().getAddrDetail(), mCarBean.getVehicleModel().getIcon());
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    protected void onStart() {
        super.onStart();
//        onShowLoading();
    }

    @Override
    public void onResume() {
        super.onResume();
        mWebView.onResume();// 生命周期onResume
    }

    @Override
    protected void onPause() {
        super.onPause();
        mWebView.onPause();//生命周期onPause
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        UMShareAPI.get(this).release();
        mWebView.stopLoading();// 停止当前加载
        mWebView.clearMatches();// 清除网页查找的高亮匹配字符。
        mWebView.clearHistory();// 清除当前 WebView 访问的历史记录
        mWebView.clearSslPreferences();//清除ssl信息
        mWebView.clearCache(true);//清空网页访问留下的缓存数据。需要注意的时，由于缓存是全局的，所以只要是WebView用到的缓存都会被清空，即便其他地方也会使用到。该方法接受一个参数，从命名即可看出作用。若设为false，则只清空内存里的资源缓存，而不清空磁盘里的。
        mWebView.loadUrl("about:blank");// 清空当前加载
        mWebView.removeAllViews();// 清空子 View
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR2) {
            mWebView.removeJavascriptInterface("AndroidNative");// 向 Web端注入 java 对象
        }
        mWebView.destroy();// 生命周期销毁
    }


    /**
     * 屏幕横竖屏切换时避免出现window leak的问题
     */
    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        shareManager.close();
    }


    private void initWeb() {
        WebSettings webSettings = mWebView.getSettings();
        if (webSettings == null) return;
        // 支持 Js 使用
        webSettings.setJavaScriptEnabled(true);
        // 开启DOM缓存,默认状态下是不支持LocalStorage的
        webSettings.setDomStorageEnabled(true);
        // 开启数据库缓存
        webSettings.setDatabaseEnabled(true);
        // 支持自动加载图片
        webSettings.setLoadsImagesAutomatically(hasKitkat());
        // 设置 WebView 的缓存模式
        webSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
        // 支持启用缓存模式
        webSettings.setAppCacheEnabled(true);
        // 设置 AppCache 最大缓存值(现在官方已经不提倡使用，已废弃)
//        webSettings.setAppCacheMaxSize(8 * 1024 * 1024);
        // Android 私有缓存存储，如果你不调用setAppCachePath方法，WebView将不会产生这个目录
        webSettings.setAppCachePath(getCacheDir().getAbsolutePath());
        // 数据库路径
//        if (!hasKitkat()) {
//            webSettings.setDatabasePath(getDatabasePath("html").getPath());
//        }
        // 关闭密码保存提醒功能
//        webSettings.setSavePassword(false);
        // 支持缩放
        webSettings.setSupportZoom(true);
        // 设置 UserAgent 属性
        webSettings.setUserAgentString("");
        // 允许加载本地 html 文件/false
        webSettings.setAllowFileAccess(true);
        // 允许通过 file url 加载的 Javascript 读取其他的本地文件,Android 4.1 之前默认是true，在 Android 4.1 及以后默认是false,也就是禁止
        webSettings.setAllowFileAccessFromFileURLs(true);
        // 允许通过 file url 加载的 Javascript 可以访问其他的源，包括其他的文件和 http，https 等其他的源，
        // Android 4.1 之前默认是true，在 Android 4.1 及以后默认是false,也就是禁止
        // 如果此设置是允许，则 setAllowFileAccessFromFileURLs 不起做用
        webSettings.setAllowUniversalAccessFromFileURLs(true);
        mWebView.addJavascriptInterface(new AndroidJs(), "AndroidJs");
        mWebView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                return super.shouldOverrideUrlLoading(view, request);
            }
        });
        mWebView.loadUrl(webUrl);
        mWebView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress == 100) {
                    pbProgress.setVisibility(View.GONE);//加载完网页进度条消失
                } else {
                    pbProgress.setVisibility(View.VISIBLE);//开始加载网页时显示进度条
                    pbProgress.setProgress(newProgress);//设置进度值
                }
            }
        });
    }

    @OnClick({R2.id.ll_item_home, R2.id.ll_item_customer_service, R2.id.tv_item_reservation})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.ll_item_home) {
            //首页

        } else if (id == R.id.ll_item_customer_service) {
            //客服
            Intent intent = new Intent(Intent.ACTION_DIAL);
            Uri uri = Uri.parse("tel:" + "4000369369");
            intent.setData(uri);
            startActivity(intent);

        } else if (id == R.id.tv_item_reservation) {
            //预约看车
            startActivity(ReservationInformationActivity.getIntent(mActivity,carId,icon,name,keyword,score,buyPrice));
        }
    }

    /**
     * 与h5交互
     */
    public class AndroidJs {
        /**
         * 显示门店地图
         */
        @JavascriptInterface
        public void showMap() {

        }
    }


    /**
     * 初始化分享
     */
    private void initShare(final String url, final String name, final String content, final String logo) {

        shareManager = new ShareManager(this, new ShareBoardlistener() {
            @Override
            public void onclick(SnsPlatform snsPlatform, SHARE_MEDIA share_media) {

                if (snsPlatform.mShowWord.equals("生成海报")) {


                } else if (snsPlatform.mShowWord.equals("复制链接")) {

                }
                shareManager.showShare(share_media, url, name, content, logo

                        , new CustomShareListener(mActivity) {
                            @Override
                            public void onResult(SHARE_MEDIA platform) {
                                super.onResult(platform);

                                if (platform.name().equals("WEIXIN_FAVORITE")) {

                                    showToast(platform + " 收藏成功啦");

                                } else {
                                    if (platform != SHARE_MEDIA.MORE && platform != SHARE_MEDIA.SMS
                                            && platform != SHARE_MEDIA.EMAIL
                                            && platform != SHARE_MEDIA.FLICKR
                                            && platform != SHARE_MEDIA.FOURSQUARE
                                            && platform != SHARE_MEDIA.TUMBLR
                                            && platform != SHARE_MEDIA.POCKET
                                            && platform != SHARE_MEDIA.PINTEREST

                                            && platform != SHARE_MEDIA.INSTAGRAM
                                            && platform != SHARE_MEDIA.GOOGLEPLUS
                                            && platform != SHARE_MEDIA.YNOTE
                                            && platform != SHARE_MEDIA.EVERNOTE) {
                                        showToast(platform + "分享成功啦");

                                    }

                                }

                            }
                        });
            }
        }, "rv_um_share_bill", "rv_um_share_copy");
    }

}
