package com.rv.rvmine.personal;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;

import com.alibaba.fastjson.JSON;
import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.frame.base.bus.IDCardCertificationEvent;
import com.frame.base.bus.RxBus;
import com.ruiwenliu.wrapper.SPConstance;
import com.ruiwenliu.wrapper.util.UtilsManager;
import com.ruiwenliu.wrapper.bean.BeanUserInfo;
import com.rv.rvmine.R2;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.base.presenter.PickerPresenter;
import com.rv.rvmine.R;
import com.yuyife.okgo.OkGoUtil;

import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * 实名认证成功
 */
public class SuccessfulCertificationActivity extends BaseStatusActivity<PickerPresenter> {
    BeanUserInfo.UserInfo userInfo = null;

    public static Intent getIntent(Context context) {
        return new Intent(context, SuccessfulCertificationActivity.class);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_successful_certification;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("身份证认证");
        String spStringCode = UtilsManager.getInstance(OkGoUtil.application).getSPStringCode(SPConstance.USER_JSON, SPConstance.USER_JSON_USERINFO);
        if (!TextUtil.isEmpty(spStringCode)) {
            userInfo = JSON.parseObject(spStringCode, BeanUserInfo.UserInfo.class);
        }
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ButterKnife.bind(this);
    }

    @OnClick(R2.id.tv_ok)
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.tv_ok){
            if (userInfo !=null){
                userInfo.setCertificationStatus(1);
                UtilsManager.getInstance(OkGoUtil.application).setSharePreferencesSave(SPConstance.USER_JSON).putString(SPConstance.USER_JSON_USERINFO, JSON.toJSONString(userInfo)).commit();
            }
            RxBus.post(new IDCardCertificationEvent());
            finish();
        }
    }
}
