package com.rv.rvmine.fragment;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.rvmine.R;
import com.rv.rvmine.R2;
import com.rv.rvmine.SwitchFragmentListener;

import butterknife.BindView;

public class BindPhoneFirstFragment extends BaseFragment<CommonPresenter> {

    @BindView(R2.id.tv_phone)
    TextView tvPhone;
    @BindView(R2.id.btn_update_phone)
    Button btnUpdatePhone;
    private String phone;

    @Override
    public int getViewLayout() {
        return R.layout.fragment_bind_phone_first;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        ((SwitchFragmentListener) _mActivity).setTitle("绑定手机号");

        phone = getArguments().getString("phone");
        if (!TextUtils.isEmpty(phone))
            tvPhone.setText(phone);
        btnUpdatePhone.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ((SwitchFragmentListener) _mActivity).next();
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState) {

    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }
}
