package com.rv.home.rv.module.ui.main.home.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.component.utils.DateUtils;
import com.rv.home.R;
import com.rv.home.rv.module.ui.main.home.bean.OrderCarPriceBean;

/**
 * 租车订单价格明细
 */

public class OrderDayCarPriceDetailAdapter extends BaseQuickAdapter<OrderCarPriceBean, BaseViewHolder> {

    public OrderDayCarPriceDetailAdapter() {
        super(R.layout.rv_item_order_day_car_price_detail);
    }

    @Override
    protected void convert(BaseViewHolder helper, OrderCarPriceBean item) {
        helper.setText(R.id.tv_date, DateUtils.formatDate14(DateUtils.formatDate11(item.getDate())));
        helper.setText(R.id.tv_price, "¥" + item.getPrice());
    }
}
