package com.rv.home.rv.module.ui.login;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;

import com.alibaba.android.arouter.launcher.ARouter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.dialog.BaseDialog;
import com.rv.home.R;
import com.rv.home.rv.module.ApiConfig;

public class PrivacyTipsDialog extends BaseDialog {

    public PrivacyTipsDialog(@NonNull Context context) {
        super(context);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
    }

    public PrivacyTipsDialog(Context context, int themeResId) {
        super(context, themeResId);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
    }

    @Override
    public int getViewLayout() {
        return R.layout.dialog_privacy_tips;
    }

    public static class Builder {

        private Context mContext;
        private Button btnDisagree, btnAgree;
        private TextView txtContent;
        private PrivacyTipsDialog dialog;
        private PrivacyListener mListener;

        public Builder(Context context, PrivacyListener listener) {
            mContext = context;
            this.mListener = listener;
        }

        public interface DownloadListener {
            void download();
        }

        public Builder show() {
            final PrivacyTipsDialog dialog = create();
            dialog.show();
            return this;
        }

        /**
         * 创建定制的对话框
         */
        public PrivacyTipsDialog create() {
            LayoutInflater inflater = (LayoutInflater) mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            dialog = new PrivacyTipsDialog(mContext, R.style.DialogActivityTheme);
            // 获取对话框的布局
            View layout = inflater.inflate(R.layout.dialog_privacy_tips, null);
            // 为对话框添加布局和设置大小
            dialog.addContentView(layout, new WindowManager.LayoutParams(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT));
            txtContent = layout.findViewById(R.id.tv_tips_content) ;
            this.btnDisagree = layout.findViewById(R.id.btn_disagree);
            this.btnAgree = layout.findViewById(R.id.btn_agree);
            this.btnAgree.setOnClickListener(v -> {
                if (mListener != null) mListener.agree();
                dialog.dismiss();
            });

            this.btnDisagree.setOnClickListener(v -> {
                if (mListener != null) mListener.disAgree();
                dialog.dismiss();
            });
            setTextColorAndAction();
            dialog.setCancelable(false);
            dialog.setContentView(layout);
            return dialog;
        }

        private void avoidHintColor(View view) {
            if (view instanceof TextView)
                ((TextView) view).setHighlightColor(mContext.getResources().getColor(android.R.color.transparent));
        }

        private void setTextColorAndAction(){
            SpannableStringBuilder ssb = new SpannableStringBuilder();
            String str = txtContent.getText().toString().trim();
            ssb.append(str);

            ssb.setSpan(new UnderlineSpan(),str.indexOf("如果您不同意以上"),str.indexOf("您停止注册后将"),0);
            ssb.setSpan(new StyleSpan(Typeface.BOLD),str.indexOf("如果您不同意以上"),str.indexOf("您停止注册后将"),0);
            ssb.setSpan(new UnderlineSpan(),str.indexOf("请您务必仔细阅读"),str.indexOf("（尤其是以粗"),0);
            ssb.setSpan(new StyleSpan(Typeface.BOLD),str.indexOf("请您务必仔细阅读"),str.indexOf("（尤其是以粗"),0);

            final int startUserAgreement = str.indexOf("《用户协议》");//第一个出现的位置
            ssb.setSpan(new ClickableSpan() {
                @Override
                public void onClick(View widget) {
                    avoidHintColor(widget);
                    ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                            .withString("title", "用户协议")
                            .withString("url", ApiConfig.HTTP_URL_CAR_TYPE_NOTICE)
                            .withInt("type", 15)
                            .navigation();
                }

                @Override
                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(mContext.getResources().getColor(R.color.gray_FFB74B));       //设置文件颜色
                    // 去掉下划线
                    ds.setUnderlineText(false);
                }

            }, startUserAgreement, startUserAgreement + 6, 0);

            final int endUserAgreement = str.lastIndexOf("《用户协议》");//最后一个出现的位置
            ssb.setSpan(new ClickableSpan() {

                @Override
                public void onClick(View widget) {
                    avoidHintColor(widget);
                    ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                            .withString("title", "用户协议")
                            .withString("url", ApiConfig.HTTP_URL_CAR_TYPE_NOTICE)
                            .withInt("type", 15)
                            .navigation();

                }

                @Override
                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(mContext.getResources().getColor(R.color.gray_FFB74B));       //设置文件颜色
                    // 去掉下划线
                    ds.setUnderlineText(false);
                }

            }, endUserAgreement, endUserAgreement + 6, 0);

            final int startPrivacyAgreement = str.indexOf("《隐私政策》");//第一个出现的位置
            ssb.setSpan(new ClickableSpan() {
                @Override
                public void onClick(View widget) {
                    avoidHintColor(widget);
                    ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                            .withString("title", "隐私政策")
                            .withString("url", ApiConfig.HTTP_URL_CAR_TYPE_NOTICE)
                            .withInt("type", 19)
                            .navigation();
                }

                @Override
                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(mContext.getResources().getColor(R.color.gray_FFB74B));       //设置文件颜色
                    // 去掉下划线
                    ds.setUnderlineText(false);
                }

            }, startPrivacyAgreement, startPrivacyAgreement + 6, 0);

            final int endPrivacyAgreement = str.lastIndexOf("《隐私政策》");//最后一个出现的位置
            ssb.setSpan(new ClickableSpan() {

                @Override
                public void onClick(View widget) {
                    avoidHintColor(widget);
                    ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                            .withString("title", "隐私政策")
                            .withString("url", ApiConfig.HTTP_URL_CAR_TYPE_NOTICE)
                            .withInt("type", 19)
                            .navigation();

                }

                @Override
                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(mContext.getResources().getColor(R.color.gray_FFB74B));       //设置文件颜色
                    // 去掉下划线
                    ds.setUnderlineText(false);
                }

            }, endPrivacyAgreement, endPrivacyAgreement + 6, 0);

            txtContent.setMovementMethod(LinkMovementMethod.getInstance());
            txtContent.setText(ssb, TextView.BufferType.SPANNABLE);
        }
    }




    public interface PrivacyListener {

        void agree();

        void disAgree();
    }

}
