package com.rv.component.utils;

import android.content.Context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;

/******
 * 缓存管理
 */
public class RvCache<T extends Serializable> {
    private static RvCache instance = null;

    private static WeakReference<Context> weakReference = null;

    private RvCache() {
    }

    public static void init(Context context) {
        weakReference = new WeakReference<>(context);
    }

    public static <T> RvCache getInstance() {
        if (instance == null) {
            synchronized (RvCache.class) {
                if (instance == null) {
                    instance = new RvCache();
                }
            }

        }
        return instance;
    }

    /********
     * 保存
     * @param bean
     */
    public void save(T bean, CacheEnum anEnum) {
        if (bean == null) {
            return;
        }
        saveObject(bean, anEnum);
    }

    private void saveObject(T bean, CacheEnum anEnum) {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        File f = new File(getSavePath(anEnum));
        try {
            fos = new FileOutputStream(f);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(bean);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getSavePath(CacheEnum anEnum) {
        return weakReference.get().getCacheDir().getPath() + File.separator + anEnum.getFileName();
    }


    public T get(CacheEnum cacheEnum) {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        T o = null;
        File f = new File(getSavePath(cacheEnum));
        if (!f.exists()) {
            return null;
        }
        try {
            fis = new FileInputStream(f);
            ois = new ObjectInputStream(fis);
            o = (T) ois.readObject();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } finally {
            try {
                if (ois != null) {
                    ois.close();
                }
                if (fis != null) {
                    fis.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return o;
    }

    public void clear() {
        clear(CacheEnum.USER);
        clear(CacheEnum.MEMBER);
        clear(CacheEnum.VISTOR_LIST);
        clear(CacheEnum.CONSUMER_RECORD);
    }

    public void clear(CacheEnum cacheEnum) {
        File f = new File(getSavePath(cacheEnum));
        if (f.exists()) {
            f.delete();
        }
    }
}
